/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import org.openrewrite.ExecutionContext;
import org.openrewrite.ParseExceptionResult;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markup;
import org.openrewrite.table.ParseFailures;

public final class FindParseFailures
extends Recipe {
    private final ParseFailures failures = new ParseFailures(this);

    @Override
    public String getDisplayName() {
        return "Find source files with `ParseExceptionResult` markers";
    }

    @Override
    public String getDescription() {
        return "This recipe explores parse failures after an LST is produced for classifying the types of failures that can occur and prioritizing fixes according to the most common problems.";
    }

    @Override
    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree visitSourceFile(SourceFile sourceFile, ExecutionContext ctx) {
                return sourceFile.getMarkers().findFirst(ParseExceptionResult.class).map(exceptionResult -> {
                    FindParseFailures.this.failures.insertRow(ctx, new ParseFailures.Row(sourceFile.getSourcePath().toString(), exceptionResult.getMessage()));
                    return Markup.info(sourceFile, exceptionResult.getMessage());
                }).orElse(sourceFile);
            }
        };
    }

    public ParseFailures getFailures() {
        return this.failures;
    }

    @NonNull
    public String toString() {
        return "FindParseFailures(failures=" + this.getFailures() + ")";
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindParseFailures)) {
            return false;
        }
        FindParseFailures other = (FindParseFailures)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParseFailures this$failures = this.getFailures();
        ParseFailures other$failures = other.getFailures();
        return !(this$failures == null ? other$failures != null : !this$failures.equals(other$failures));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindParseFailures;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ParseFailures $failures = this.getFailures();
        result = result * 59 + ($failures == null ? 43 : $failures.hashCode());
        return result;
    }
}

