/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.fasterxml.jackson.core.type.TypeReference;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.intellij.lang.annotations.Language;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;

@JsonIgnoreType
@Incubating(since="7.35.0")
public class DataTable<Row> {
    private final String name;
    private final Class<Row> type;
    @Language(value="markdown")
    private final String displayName;
    @Language(value="markdown")
    private final String description;
    private boolean enabled = true;

    public DataTable(Recipe recipe, Class<Row> type, String name, @Language(value="markdown") String displayName, @Language(value="markdown") String description) {
        this.type = type;
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        recipe.addDataTable(this);
    }

    public DataTable(Recipe recipe, @Language(value="markdown") String displayName, @Language(value="markdown") String description) {
        this.type = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        this.name = this.getClass().getName();
        this.displayName = displayName;
        this.description = description;
        recipe.addDataTable(this);
    }

    public TypeReference<List<Row>> getRowsTypeReference() {
        return new TypeReference<List<Row>>(){};
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void insertRow(ExecutionContext ctx, Row row) {
        if (this.enabled) {
            ctx.computeMessage("org.openrewrite.dataTables", row, ConcurrentHashMap::new, (extract, allDataTables) -> {
                List dataTablesOfType = (List)allDataTables.computeIfAbsent(this, c -> new ArrayList());
                dataTablesOfType.add(row);
                return allDataTables;
            });
        }
    }

    public String getName() {
        return this.name;
    }

    public Class<Row> getType() {
        return this.type;
    }

    @Language(value="markdown")
    public String getDisplayName() {
        return this.displayName;
    }

    @Language(value="markdown")
    public String getDescription() {
        return this.description;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

