/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shaded.jgit.api;

import java.io.IOException;
import org.openrewrite.shaded.jgit.api.GitCommand;
import org.openrewrite.shaded.jgit.api.errors.GitAPIException;
import org.openrewrite.shaded.jgit.api.errors.JGitInternalException;
import org.openrewrite.shaded.jgit.lib.CommitBuilder;
import org.openrewrite.shaded.jgit.lib.ObjectId;
import org.openrewrite.shaded.jgit.lib.ObjectInserter;
import org.openrewrite.shaded.jgit.lib.PersonIdent;
import org.openrewrite.shaded.jgit.lib.Ref;
import org.openrewrite.shaded.jgit.lib.RefUpdate;
import org.openrewrite.shaded.jgit.lib.Repository;
import org.openrewrite.shaded.jgit.notes.Note;
import org.openrewrite.shaded.jgit.notes.NoteMap;
import org.openrewrite.shaded.jgit.revwalk.RevCommit;
import org.openrewrite.shaded.jgit.revwalk.RevObject;
import org.openrewrite.shaded.jgit.revwalk.RevWalk;

public class AddNoteCommand
extends GitCommand<Note> {
    private RevObject id;
    private String message;
    private String notesRef = "refs/notes/commits";

    protected AddNoteCommand(Repository repo) {
        super(repo);
    }

    /*
     * Loose catch block
     */
    @Override
    public Note call() throws GitAPIException {
        this.checkCallable();
        NoteMap map = NoteMap.newEmptyMap();
        RevCommit notesCommit = null;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                Note note;
                ObjectInserter inserter;
                RevWalk walk;
                block19: {
                    walk = new RevWalk(this.repo);
                    inserter = this.repo.newObjectInserter();
                    Ref ref = this.repo.findRef(this.notesRef);
                    if (ref != null) {
                        notesCommit = walk.parseCommit(ref.getObjectId());
                        map = NoteMap.read(walk.getObjectReader(), notesCommit);
                    }
                    map.set(this.id, this.message, inserter);
                    AddNoteCommand.commitNoteMap(this.repo, this.notesRef, walk, map, notesCommit, inserter, "Notes added by 'git notes add'");
                    note = map.getNote(this.id);
                    if (inserter != null) {
                        inserter.close();
                    }
                    if (walk == null) break block19;
                    walk.close();
                }
                return note;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (inserter != null) {
                                inserter.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (walk != null) {
                                walk.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    public AddNoteCommand setObjectId(RevObject id) {
        this.checkCallable();
        this.id = id;
        return this;
    }

    public AddNoteCommand setMessage(String message) {
        this.checkCallable();
        this.message = message;
        return this;
    }

    static void commitNoteMap(Repository r, String ref, RevWalk walk, NoteMap map, RevCommit notesCommit, ObjectInserter inserter, String msg) throws IOException {
        CommitBuilder builder = new CommitBuilder();
        builder.setTreeId(map.writeTree(inserter));
        builder.setAuthor(new PersonIdent(r));
        builder.setCommitter(builder.getAuthor());
        builder.setMessage(msg);
        if (notesCommit != null) {
            builder.setParentIds(notesCommit);
        }
        ObjectId commit = inserter.insert(builder);
        inserter.flush();
        RefUpdate refUpdate = r.updateRef(ref);
        if (notesCommit != null) {
            refUpdate.setExpectedOldObjectId(notesCommit);
        } else {
            refUpdate.setExpectedOldObjectId(ObjectId.zeroId());
        }
        refUpdate.setNewObjectId(commit);
        refUpdate.update(walk);
    }

    public AddNoteCommand setNotesRef(String notesRef) {
        this.checkCallable();
        this.notesRef = notesRef;
        return this;
    }
}

