/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marker.ci;

import java.util.UUID;
import java.util.function.UnaryOperator;
import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.GitProvenance;
import org.openrewrite.marker.ci.BuildEnvironment;
import org.openrewrite.marker.ci.IncompleteGitConfigException;

public final class CustomBuildEnvironment
implements BuildEnvironment {
    private final UUID id;
    private final String cloneURL;
    private final String ref;
    private final String sha;

    public static CustomBuildEnvironment build(UnaryOperator<String> environment) {
        return new CustomBuildEnvironment(Tree.randomId(), (String)environment.apply("CUSTOM_GIT_CLONE_URL"), (String)environment.apply("CUSTOM_GIT_REF"), (String)environment.apply("CUSTOM_GIT_SHA"));
    }

    @Override
    public GitProvenance buildGitProvenance() throws IncompleteGitConfigException {
        if (StringUtils.isBlank(this.cloneURL) || StringUtils.isBlank(this.ref) || StringUtils.isBlank(this.sha)) {
            throw new IncompleteGitConfigException();
        }
        return new GitProvenance(UUID.randomUUID(), this.cloneURL, this.ref, this.sha, null, null);
    }

    public CustomBuildEnvironment(UUID id, String cloneURL, String ref, String sha) {
        this.id = id;
        this.cloneURL = cloneURL;
        this.ref = ref;
        this.sha = sha;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    public String getCloneURL() {
        return this.cloneURL;
    }

    public String getRef() {
        return this.ref;
    }

    public String getSha() {
        return this.sha;
    }

    @NonNull
    public String toString() {
        return "CustomBuildEnvironment(id=" + this.getId() + ", cloneURL=" + this.getCloneURL() + ", ref=" + this.getRef() + ", sha=" + this.getSha() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomBuildEnvironment)) {
            return false;
        }
        CustomBuildEnvironment other = (CustomBuildEnvironment)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$cloneURL = this.getCloneURL();
        String other$cloneURL = other.getCloneURL();
        if (this$cloneURL == null ? other$cloneURL != null : !this$cloneURL.equals(other$cloneURL)) {
            return false;
        }
        String this$ref = this.getRef();
        String other$ref = other.getRef();
        if (this$ref == null ? other$ref != null : !this$ref.equals(other$ref)) {
            return false;
        }
        String this$sha = this.getSha();
        String other$sha = other.getSha();
        return !(this$sha == null ? other$sha != null : !this$sha.equals(other$sha));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $cloneURL = this.getCloneURL();
        result = result * 59 + ($cloneURL == null ? 43 : $cloneURL.hashCode());
        String $ref = this.getRef();
        result = result * 59 + ($ref == null ? 43 : $ref.hashCode());
        String $sha = this.getSha();
        result = result * 59 + ($sha == null ? 43 : $sha.hashCode());
        return result;
    }

    @NonNull
    public CustomBuildEnvironment withId(UUID id) {
        return this.id == id ? this : new CustomBuildEnvironment(id, this.cloneURL, this.ref, this.sha);
    }
}

