/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.text;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.binary.Binary;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.quark.Quark;
import org.openrewrite.remote.Remote;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextParser;

public final class Find
extends Recipe {
    private static final String SR_PREFIX = "~~>(";
    private static final int SR_LENGTH = "~~>(".length();
    @Option(displayName="Find", description="The text to find.", example="blacklist")
    private final String find;
    @Option(displayName="Regex", description="Default false. If true, `find` will be interpreted as a Regular Expression.", required=false)
    @Nullable
    private final Boolean regex;

    @Override
    public String getDisplayName() {
        return "Find text";
    }

    @Override
    public String getDescription() {
        return "Search for text in a plain text file. Wraps the results in \"~~>( )\".";
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree visitSourceFile(SourceFile sourceFile, ExecutionContext executionContext) {
                if (sourceFile instanceof Quark || sourceFile instanceof Remote || sourceFile instanceof Binary) {
                    return sourceFile;
                }
                PlainText plainText = PlainTextParser.convert(sourceFile);
                String searchStr = Find.this.find;
                if (!Boolean.TRUE.equals(Find.this.regex)) {
                    searchStr = Pattern.quote(searchStr);
                }
                Pattern pattern = Pattern.compile(searchStr);
                Matcher matcher = pattern.matcher(plainText.getText());
                String rawText = plainText.getText();
                StringBuilder result = new StringBuilder();
                boolean anyFound = false;
                int previousEnd = 0;
                while (matcher.find()) {
                    anyFound = true;
                    int matchStart = matcher.start();
                    result.append(rawText, previousEnd, matchStart);
                    if (matchStart >= SR_LENGTH && rawText.substring(matchStart - SR_LENGTH, matchStart).equals(Find.SR_PREFIX)) {
                        result.append(rawText, matchStart, matcher.end());
                    } else {
                        result.append(Find.SR_PREFIX).append(rawText, matchStart, matcher.end()).append(")");
                    }
                    previousEnd = matcher.end();
                }
                if (anyFound) {
                    result.append(rawText.substring(previousEnd));
                    String newText = result.toString();
                    if (!newText.equals(rawText)) {
                        plainText = plainText.withText(newText);
                    }
                }
                return plainText;
            }
        };
    }

    public Find(String find, @Nullable Boolean regex) {
        this.find = find;
        this.regex = regex;
    }

    public String getFind() {
        return this.find;
    }

    @Nullable
    public Boolean getRegex() {
        return this.regex;
    }

    @NonNull
    public String toString() {
        return "Find(find=" + this.getFind() + ", regex=" + this.getRegex() + ")";
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Find)) {
            return false;
        }
        Find other = (Find)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$regex = this.getRegex();
        Boolean other$regex = other.getRegex();
        if (this$regex == null ? other$regex != null : !((Object)this$regex).equals(other$regex)) {
            return false;
        }
        String this$find = this.getFind();
        String other$find = other.getFind();
        return !(this$find == null ? other$find != null : !this$find.equals(other$find));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof Find;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $regex = this.getRegex();
        result = result * 59 + ($regex == null ? 43 : ((Object)$regex).hashCode());
        String $find = this.getFind();
        result = result * 59 + ($find == null ? 43 : $find.hashCode());
        return result;
    }
}

