/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.table;

import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public class SourcesFileResults
extends DataTable<Row> {
    public SourcesFileResults(Recipe recipe) {
        super(recipe, "Source files that had results", "Source files that were modified by the recipe run.");
    }

    public static final class Row {
        @Column(displayName="Source path before the run", description="The source path of the file before the run.")
        private final String sourcePath;
        @Column(displayName="Source path after the run", description="A recipe may modify the source path. This is the path after the run.")
        private final String afterSourcePath;
        @Column(displayName="Parent of the recipe that made changes", description="In a hierarchical recipe, the parent of the recipe that made a change. Empty ifthis is the root of a hierarchy or if the recipe is not hierarchical at all.")
        private final String parentRecipe;
        @Column(displayName="Recipe that made changes", description="The specific recipe that made a change.")
        private final String recipe;

        public Row(String sourcePath, String afterSourcePath, String parentRecipe, String recipe) {
            this.sourcePath = sourcePath;
            this.afterSourcePath = afterSourcePath;
            this.parentRecipe = parentRecipe;
            this.recipe = recipe;
        }

        public String getSourcePath() {
            return this.sourcePath;
        }

        public String getAfterSourcePath() {
            return this.afterSourcePath;
        }

        public String getParentRecipe() {
            return this.parentRecipe;
        }

        public String getRecipe() {
            return this.recipe;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            String this$sourcePath = this.getSourcePath();
            String other$sourcePath = other.getSourcePath();
            if (this$sourcePath == null ? other$sourcePath != null : !this$sourcePath.equals(other$sourcePath)) {
                return false;
            }
            String this$afterSourcePath = this.getAfterSourcePath();
            String other$afterSourcePath = other.getAfterSourcePath();
            if (this$afterSourcePath == null ? other$afterSourcePath != null : !this$afterSourcePath.equals(other$afterSourcePath)) {
                return false;
            }
            String this$parentRecipe = this.getParentRecipe();
            String other$parentRecipe = other.getParentRecipe();
            if (this$parentRecipe == null ? other$parentRecipe != null : !this$parentRecipe.equals(other$parentRecipe)) {
                return false;
            }
            String this$recipe = this.getRecipe();
            String other$recipe = other.getRecipe();
            return !(this$recipe == null ? other$recipe != null : !this$recipe.equals(other$recipe));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sourcePath = this.getSourcePath();
            result = result * 59 + ($sourcePath == null ? 43 : $sourcePath.hashCode());
            String $afterSourcePath = this.getAfterSourcePath();
            result = result * 59 + ($afterSourcePath == null ? 43 : $afterSourcePath.hashCode());
            String $parentRecipe = this.getParentRecipe();
            result = result * 59 + ($parentRecipe == null ? 43 : $parentRecipe.hashCode());
            String $recipe = this.getRecipe();
            result = result * 59 + ($recipe == null ? 43 : $recipe.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "SourcesFileResults.Row(sourcePath=" + this.getSourcePath() + ", afterSourcePath=" + this.getAfterSourcePath() + ", parentRecipe=" + this.getParentRecipe() + ", recipe=" + this.getRecipe() + ")";
        }
    }
}

