/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote;

import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.UUID;
import org.intellij.lang.annotations.Language;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.HttpSenderExecutionContextView;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.ipc.http.HttpSender;
import org.openrewrite.ipc.http.HttpUrlConnectionSender;
import org.openrewrite.marker.Markers;
import org.openrewrite.remote.RemoteArchive;
import org.openrewrite.remote.RemoteFile;
import org.openrewrite.remote.RemoteVisitor;

public interface Remote
extends SourceFile {
    public URI getUri();

    public <R extends Remote> R withUri(URI var1);

    public String getDescription();

    public <R extends Remote> R withDescription(String var1);

    @Override
    @Nullable
    default public Checksum getChecksum() {
        return null;
    }

    @Override
    default public <T extends SourceFile> T withChecksum(@Nullable Checksum checksum) {
        return (T)this;
    }

    public InputStream getInputStream(HttpSender var1);

    @Override
    default public <P> String printAll(P p) {
        return StringUtils.readFully(this.getInputStream(new HttpUrlConnectionSender()), StandardCharsets.UTF_8);
    }

    @Override
    default public <P> String printAllTrimmed(P p) {
        return StringUtils.trimIndentPreserveCRLF(this.printAll(p));
    }

    @Override
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)v.adapt(RemoteVisitor.class).visitRemote(this, p);
    }

    @Override
    default public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v.isAdaptableTo(RemoteVisitor.class);
    }

    public static Builder builder(SourceFile before, URI uri) {
        return new Builder(before.getId(), before.getSourcePath(), before.getMarkers(), uri);
    }

    public static Builder builder(Path sourcePath, URI uri) {
        return new Builder(Tree.randomId(), sourcePath, Markers.EMPTY, uri);
    }

    public static Builder builder(UUID id, Path sourcePath, Markers markers, URI uri) {
        return new Builder(id, sourcePath, markers, uri);
    }

    @Override
    default public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
        return new TreeVisitor<Tree, PrintOutputCapture<P>>(){

            @Override
            public Tree visitSourceFile(SourceFile sourceFile, PrintOutputCapture<P> p) {
                ExecutionContext ctx = p.getContext() instanceof ExecutionContext ? (ExecutionContext)p.getContext() : new InMemoryExecutionContext();
                HttpSender sender = HttpSenderExecutionContextView.view(ctx).getHttpSender();
                p.out.append(StringUtils.readFully(Remote.this.getInputStream(sender), StandardCharsets.UTF_8));
                return sourceFile;
            }
        };
    }

    public static class Builder {
        protected final UUID id;
        protected final Path sourcePath;
        protected final Markers markers;
        protected final URI uri;
        @Nullable
        @Language(value="markdown")
        protected String description;
        @Nullable
        protected Checksum checksum;
        @Nullable
        Charset charset;
        boolean charsetBomMarked;
        @Nullable
        FileAttributes fileAttributes;

        Builder(UUID id, Path sourcePath, Markers markers, URI uri) {
            this.id = id;
            this.sourcePath = sourcePath;
            this.markers = markers;
            this.uri = uri;
        }

        public Builder description(@Language(value="markdown") String description) {
            this.description = description;
            return this;
        }

        public Builder charset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder charsetBomMarked(boolean charsetBomMarked) {
            this.charsetBomMarked = charsetBomMarked;
            return this;
        }

        public Builder fileAttributes(FileAttributes fileAttributes) {
            this.fileAttributes = fileAttributes;
            return this;
        }

        public RemoteFile build() {
            return new RemoteFile(this.id, this.sourcePath, this.markers, this.uri, this.charset, this.charsetBomMarked, this.fileAttributes, this.description);
        }

        public RemoteArchive build(Path path) {
            return new RemoteArchive(this.id, this.sourcePath, this.markers, this.uri, this.charset, this.charsetBomMarked, this.fileAttributes, this.description, Arrays.asList(path.toString().replace("/", "\\/").replace(".", "\\.").split("!")));
        }

        public RemoteArchive build(String ... paths) {
            return new RemoteArchive(this.id, this.sourcePath, this.markers, this.uri, this.charset, this.charsetBomMarked, this.fileAttributes, this.description, Arrays.asList(paths));
        }
    }
}

