/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.text;

import java.util.function.UnaryOperator;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.marker.Marker;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextVisitor;

public class PlainTextPrinter<P>
extends PlainTextVisitor<PrintOutputCapture<P>> {
    private static final UnaryOperator<String> TEXT_MARKER_WRAPPER = out -> "~~" + out + (out.isEmpty() ? "" : "~~") + ">";

    @Override
    public PlainText visitText(PlainText text, PrintOutputCapture<P> p) {
        for (Marker marker : text.getMarkers().getMarkers()) {
            p.out.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), marker), TEXT_MARKER_WRAPPER));
        }
        this.visitMarkers(text.getMarkers(), p);
        for (Marker marker : text.getMarkers().getMarkers()) {
            p.out.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), marker), TEXT_MARKER_WRAPPER));
        }
        p.out.append(text.getText());
        for (Marker marker : text.getMarkers().getMarkers()) {
            p.out.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(this.getCursor(), marker), TEXT_MARKER_WRAPPER));
        }
        return text;
    }
}

