/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeRun;
import org.openrewrite.RecipeRunStats;
import org.openrewrite.RecipeSchedulerUtils;
import org.openrewrite.RecipeTimeoutException;
import org.openrewrite.Result;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.internal.ExceptionUtils;
import org.openrewrite.internal.FindRecipeRunException;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.MetricsHelper;
import org.openrewrite.internal.RecipeRunException;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Generated;
import org.openrewrite.marker.Markup;
import org.openrewrite.marker.RecipesThatMadeChanges;
import org.openrewrite.scheduling.WatchableExecutionContext;
import org.openrewrite.table.SourcesFileErrors;
import org.openrewrite.table.SourcesFileResults;

public interface RecipeScheduler {
    default public <T> List<T> mapAsync(List<T> input, BiFunction<T, Integer, T> mapFn) {
        CompletableFuture[] futures = new CompletableFuture[input.size()];
        int k = 0;
        int i = 0;
        while (i < input.size()) {
            Object before = input.get(i);
            int index = i++;
            Callable<Object> updateTreeFn = () -> mapFn.apply(before, index);
            futures[k++] = this.schedule(updateTreeFn);
        }
        CompletableFuture.allOf(futures).join();
        return ListUtils.map(input, (j, in) -> futures[j].join());
    }

    default public RecipeRun scheduleRun(Recipe recipe, List<? extends SourceFile> before, ExecutionContext ctx, int maxCycles, int minCycles) {
        List<? extends SourceFile> acc;
        org.openrewrite.table.RecipeRunStats runStatsTable = new org.openrewrite.table.RecipeRunStats(Recipe.noop());
        RecipeRunStats runStats = new RecipeRunStats(recipe);
        RecipeRun recipeRun = new RecipeRun(runStats, Collections.emptyList(), Collections.emptyMap());
        HashSet sourceFileIds = new HashSet();
        before = ListUtils.map(before, sourceFile -> {
            if (!sourceFileIds.add(sourceFile.getId())) {
                return (SourceFile)sourceFile.withId(Tree.randomId());
            }
            return sourceFile;
        });
        DistributionSummary.builder((String)"rewrite.recipe.run").tag("recipe", recipe.getDisplayName()).description("The distribution of recipe runs and the size of source file batches given to them to process.").baseUnit("source files").register((MeterRegistry)Metrics.globalRegistry).record((double)before.size());
        HashMap<UUID, Stack<Recipe>> recipeThatAddedOrDeletedSourceFile = new HashMap<UUID, Stack<Recipe>>();
        List<? extends SourceFile> after = acc = before;
        WatchableExecutionContext ctxWithWatch = new WatchableExecutionContext(ctx);
        for (int i = 0; i < maxCycles && ctx.getMessage("__AHHH_PANIC!!!__") == null; ++i) {
            Stack<Recipe> recipeStack = new Stack<Recipe>();
            recipeStack.push(recipe);
            after = this.scheduleVisit(runStats, recipeStack, acc, null, ctxWithWatch, recipeThatAddedOrDeletedSourceFile);
            if (i + 1 >= minCycles && (after == acc && !ctxWithWatch.hasNewMessages() || !recipe.causesAnotherCycle())) break;
            acc = after;
            ctxWithWatch.resetHasNewMessages();
        }
        if (after == before) {
            runStatsTable.record(ctx, recipe, runStats);
            return recipeRun.withDataTables(ctx.getMessage("org.openrewrite.dataTables", Collections.emptyMap()));
        }
        HashMap<UUID, SourceFile> sourceFileIdentities = new HashMap<UUID, SourceFile>();
        for (SourceFile sourceFile2 : before) {
            sourceFileIdentities.put(sourceFile2.getId(), sourceFile2);
        }
        ArrayList<Result> results = new ArrayList<Result>();
        for (SourceFile sourceFile3 : after) {
            SourceFile sourceFile4 = (SourceFile)sourceFileIdentities.get(sourceFile3.getId());
            if (sourceFile4 == sourceFile3) continue;
            if (sourceFile4 == null) {
                results.add(new Result(null, sourceFile3, Collections.singletonList((Stack)recipeThatAddedOrDeletedSourceFile.get(sourceFile3.getId()))));
                continue;
            }
            if (sourceFile4.getMarkers().findFirst(Generated.class).isPresent()) continue;
            results.add(new Result(sourceFile4, sourceFile3, sourceFile3.getMarkers().findFirst(RecipesThatMadeChanges.class).orElseThrow(() -> new IllegalStateException("SourceFile changed but no recipe reported making a change")).getRecipes()));
        }
        HashSet<UUID> hashSet = new HashSet<UUID>();
        for (SourceFile sourceFile5 : after) {
            hashSet.add(sourceFile5.getId());
        }
        for (SourceFile sourceFile6 : before) {
            if (hashSet.contains(sourceFile6.getId()) || sourceFile6.getMarkers().findFirst(Generated.class).isPresent()) continue;
            results.add(new Result(sourceFile6, null, Collections.singleton((Stack)recipeThatAddedOrDeletedSourceFile.get(sourceFile6.getId()))));
        }
        for (Result result : results) {
            SourcesFileResults resultsTable = new SourcesFileResults(Recipe.noop());
            Stack<RecipeDescriptor[]> recipeStack = new Stack<RecipeDescriptor[]>();
            for (RecipeDescriptor rd : result.getRecipeDescriptorsThatMadeChanges()) {
                recipeStack.push(new RecipeDescriptor[]{null, rd});
            }
            while (!recipeStack.isEmpty()) {
                RecipeDescriptor[] recipeThatMadeChange = (RecipeDescriptor[])recipeStack.pop();
                resultsTable.insertRow(ctx, new SourcesFileResults.Row(result.getBefore() == null ? "" : result.getBefore().getSourcePath().toString(), result.getAfter() == null ? "" : result.getAfter().getSourcePath().toString(), recipeThatMadeChange[0] == null ? "" : recipeThatMadeChange[0].getName(), recipeThatMadeChange[1].getName()));
                for (RecipeDescriptor rd : recipeThatMadeChange[1].getRecipeList()) {
                    recipeStack.push(new RecipeDescriptor[]{recipeThatMadeChange[1], rd});
                }
            }
        }
        runStatsTable.record(ctx, recipe, runStats);
        return recipeRun.withResults(results).withDataTables(ctx.getMessage("org.openrewrite.dataTables", Collections.emptyMap()));
    }

    default public <S extends SourceFile> List<S> scheduleVisit(RecipeRunStats runStats, Stack<Recipe> recipeStack, List<S> before, @Nullable Map<UUID, Boolean> singleSourceApplicableTestResult, ExecutionContext ctx, Map<UUID, Stack<Recipe>> recipeThatAddedOrDeletedSourceFile) {
        List<SourceFile> afterWidened;
        List<SourceFile> after;
        boolean hasSingleSourceApplicableTest;
        runStats.calls.incrementAndGet();
        long startTime = System.nanoTime();
        Recipe recipe = recipeStack.peek();
        ctx.putCurrentRecipe(recipe);
        if (ctx instanceof WatchableExecutionContext) {
            ((WatchableExecutionContext)ctx).resetHasNewMessages();
        }
        try {
            if (!recipe.getApplicableTests().isEmpty()) {
                boolean anySourceMatch = false;
                for (SourceFile s2 : before) {
                    if (!RecipeSchedulerUtils.applicableListTests(s2, recipe.getApplicableTests(), ctx)) continue;
                    anySourceMatch = true;
                    break;
                }
                if (!anySourceMatch) {
                    return before;
                }
            }
            if (!recipe.getSingleSourceApplicableTests().isEmpty() && (singleSourceApplicableTestResult == null || singleSourceApplicableTestResult.isEmpty())) {
                if (singleSourceApplicableTestResult == null) {
                    singleSourceApplicableTestResult = new HashMap<UUID, Boolean>(before.size());
                }
                for (SourceFile s3 : before) {
                    singleSourceApplicableTestResult.put(s3.getId(), RecipeSchedulerUtils.applicableListTests(s3, recipe.getSingleSourceApplicableTests(), ctx));
                }
            }
        }
        catch (Throwable t) {
            return RecipeSchedulerUtils.handleUncaughtException(recipeStack, recipeThatAddedOrDeletedSourceFile, before, ctx, recipe, t);
        }
        SourcesFileErrors errorsTable = new SourcesFileErrors(Recipe.noop());
        AtomicBoolean thrownErrorOnTimeout = new AtomicBoolean(false);
        Map<UUID, Boolean> singleSourceApplicableTestResultRef = singleSourceApplicableTestResult;
        boolean bl = hasSingleSourceApplicableTest = singleSourceApplicableTestResult != null && !singleSourceApplicableTestResult.isEmpty();
        if (!recipe.validate(ctx).isValid()) {
            after = before;
        } else {
            long getVisitorStartTime = System.nanoTime();
            after = this.mapAsync(before, (s, index) -> {
                SourceFile afterFile;
                Timer.Sample sample;
                Timer.Builder timer;
                block14: {
                    timer = Timer.builder((String)"rewrite.recipe.visit").tag("recipe", recipe.getDisplayName());
                    sample = Timer.start();
                    afterFile = s;
                    try {
                        if (hasSingleSourceApplicableTest && singleSourceApplicableTestResultRef.containsKey(s.getId()) && !((Boolean)singleSourceApplicableTestResultRef.get(s.getId())).booleanValue()) {
                            return s;
                        }
                        Duration duration = Duration.ofNanos(System.nanoTime() - startTime);
                        if (duration.compareTo(ctx.getRunTimeout(before.size())) > 0) {
                            if (thrownErrorOnTimeout.compareAndSet(false, true)) {
                                RecipeTimeoutException t = new RecipeTimeoutException(recipe);
                                ctx.getOnError().accept(t);
                                ctx.getOnTimeout().accept(t, ctx);
                            }
                            sample.stop(MetricsHelper.successTags(timer, "timeout").register((MeterRegistry)Metrics.globalRegistry));
                            return s;
                        }
                        if (ctx.getMessage("__AHHH_PANIC!!!__") != null) {
                            sample.stop(MetricsHelper.successTags(timer, "panic").register((MeterRegistry)Metrics.globalRegistry));
                            return s;
                        }
                        TreeVisitor<?, ExecutionContext> visitor = recipe.getVisitor();
                        afterFile = (SourceFile)visitor.visitSourceFile((SourceFile)s, ctx);
                        if (visitor.isAcceptable((SourceFile)s, ctx)) {
                            afterFile = (SourceFile)visitor.visit(afterFile, ctx);
                        }
                    }
                    catch (Throwable t) {
                        sample.stop(MetricsHelper.errorTags(timer, t).register((MeterRegistry)Metrics.globalRegistry));
                        ctx.getOnError().accept(t);
                        if (t instanceof RecipeRunException) {
                            RecipeRunException vt = (RecipeRunException)t;
                            afterFile = (SourceFile)new FindRecipeRunException(vt).visitNonNull(Objects.requireNonNull(afterFile), 0);
                        } else if (afterFile != null) {
                            afterFile = Markup.error(afterFile, t);
                        }
                        if (s == null) break block14;
                        errorsTable.insertRow(ctx, new SourcesFileErrors.Row(s.getSourcePath().toString(), recipe.getName(), ExceptionUtils.sanitizeStackTrace(t, RecipeScheduler.class)));
                    }
                }
                if (afterFile != null && afterFile != s) {
                    afterFile = RecipeSchedulerUtils.addRecipesThatMadeChanges(recipeStack, afterFile);
                    sample.stop(MetricsHelper.successTags(timer, "changed").register((MeterRegistry)Metrics.globalRegistry));
                } else if (afterFile == null) {
                    recipeThatAddedOrDeletedSourceFile.put(Objects.requireNonNull(s).getId(), recipeStack);
                    sample.stop(MetricsHelper.successTags(timer, "deleted").register((MeterRegistry)Metrics.globalRegistry));
                } else {
                    sample.stop(MetricsHelper.successTags(timer, "unchanged").register((MeterRegistry)Metrics.globalRegistry));
                }
                return afterFile;
            });
            runStats.ownGetVisitor.addAndGet(System.nanoTime() - getVisitorStartTime);
        }
        Map<UUID, Boolean> lastSingleSourceApplicableTestResult = singleSourceApplicableTestResult;
        HashMap newSingleSourceApplicableTestResult = new HashMap();
        try {
            long ownVisitStartTime = System.nanoTime();
            if (hasSingleSourceApplicableTest) {
                boolean anyFilePassedSingleApplicableTest = false;
                for (Boolean bl2 : singleSourceApplicableTestResult.values()) {
                    if (!bl2.booleanValue()) continue;
                    anyFilePassedSingleApplicableTest = true;
                    break;
                }
                if (!anyFilePassedSingleApplicableTest) {
                    return after;
                }
            }
            afterWidened = recipe.visit(after, ctx);
            if (hasSingleSourceApplicableTest) {
                HashMap<UUID, SourceFile> originalMap = new HashMap<UUID, SourceFile>(after.size());
                for (SourceFile sourceFile : after) {
                    originalMap.put(sourceFile.getId(), sourceFile);
                }
                afterWidened = ListUtils.map(afterWidened, s -> {
                    Boolean singleSourceTestResult = (Boolean)lastSingleSourceApplicableTestResult.get(s.getId());
                    if (singleSourceTestResult != null) {
                        newSingleSourceApplicableTestResult.put(s.getId(), singleSourceTestResult);
                        if (!singleSourceTestResult.booleanValue()) {
                            return (SourceFile)originalMap.get(s.getId());
                        }
                    } else {
                        newSingleSourceApplicableTestResult.put(s.getId(), true);
                    }
                    return s;
                });
            }
            runStats.ownVisit.addAndGet(System.nanoTime() - ownVisitStartTime);
        }
        catch (Throwable t) {
            return RecipeSchedulerUtils.handleUncaughtException(recipeStack, recipeThatAddedOrDeletedSourceFile, before, ctx, recipe, t);
        }
        if (afterWidened != after) {
            HashMap<UUID, SourceFile> originalMap = new HashMap<UUID, SourceFile>(after.size());
            for (SourceFile file : after) {
                originalMap.put(file.getId(), file);
            }
            afterWidened = ListUtils.map(afterWidened, s -> {
                SourceFile original = (SourceFile)originalMap.get(s.getId());
                if (original == null) {
                    recipeThatAddedOrDeletedSourceFile.put(s.getId(), recipeStack);
                } else if (s != original) {
                    ArrayList<Stack<Recipe>> recipeStackList = new ArrayList<Stack<Recipe>>(1);
                    recipeStackList.add(recipeStack);
                    return (SourceFile)s.withMarkers(s.getMarkers().computeByType(new RecipesThatMadeChanges(Tree.randomId(), recipeStackList), (r1, r2) -> {
                        r1.getRecipes().addAll(r2.getRecipes());
                        return r1;
                    }));
                }
                return s;
            });
            for (SourceFile maybeDeleted : after) {
                if (afterWidened.contains(maybeDeleted)) continue;
                recipeThatAddedOrDeletedSourceFile.put(maybeDeleted.getId(), recipeStack);
            }
        }
        for (Recipe r : recipe.getRecipeList()) {
            if (ctx.getMessage("__AHHH_PANIC!!!__") != null) {
                return afterWidened;
            }
            Stack<Recipe> nextStack = new Stack<Recipe>();
            nextStack.addAll(recipeStack);
            nextStack.push(r);
            RecipeRunStats nextStats = null;
            for (RecipeRunStats called : runStats.getCalled()) {
                if (called.recipe != r) continue;
                nextStats = called;
                break;
            }
            if (nextStats == null) {
                nextStats = new RecipeRunStats(r);
                runStats.getCalled().add(nextStats);
            }
            HashMap<UUID, Boolean> hashMap = new HashMap<UUID, Boolean>(newSingleSourceApplicableTestResult);
            afterWidened = this.scheduleVisit(Objects.requireNonNull(nextStats), nextStack, afterWidened, hashMap, ctx, recipeThatAddedOrDeletedSourceFile);
        }
        long totalTime = System.nanoTime() - startTime;
        runStats.max.compareAndSet(Math.min(runStats.max.get(), totalTime), totalTime);
        runStats.cumulative.addAndGet(totalTime);
        return afterWidened;
    }

    public <T> CompletableFuture<T> schedule(Callable<T> var1);
}

