/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.text;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.text.PlainText;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;

public class PlainTextParser
implements Parser<PlainText> {
    public static PlainText convert(SourceFile sourceFile) {
        if (sourceFile instanceof PlainText) {
            return (PlainText)sourceFile;
        }
        PlainText text = (PlainText)((SourceFile)PlainTextParser.builder().build().parse(sourceFile.printAll()).get(0)).withSourcePath(sourceFile.getSourcePath()).withFileAttributes(sourceFile.getFileAttributes()).withCharsetBomMarked(sourceFile.isCharsetBomMarked()).withId(sourceFile.getId());
        if (sourceFile.getCharset() != null) {
            text = (PlainText)text.withCharset(sourceFile.getCharset());
        }
        return text;
    }

    @Override
    public List<PlainText> parseInputs(Iterable<Parser.Input> sources, @Nullable Path relativeTo, ExecutionContext ctx) {
        ArrayList<PlainText> plainTexts = new ArrayList<PlainText>();
        ParsingEventListener parsingListener = ParsingExecutionContextView.view(ctx).getParsingListener();
        for (Parser.Input source : sources) {
            Path path = source.getRelativePath(relativeTo);
            try {
                EncodingDetectingInputStream is = source.getSource(ctx);
                String sourceStr = is.readFully();
                PlainText plainText = new PlainText(Tree.randomId(), path, Markers.EMPTY, is.getCharset().name(), is.isCharsetBomMarked(), source.getFileAttributes(), null, sourceStr);
                plainTexts.add(plainText);
                parsingListener.parsed(source, plainText);
            }
            catch (Throwable t) {
                ParsingExecutionContextView.view(ctx).parseFailure(source, relativeTo, this, t);
                ctx.getOnError().accept(t);
            }
        }
        return plainTexts;
    }

    @Override
    public boolean accept(Path path) {
        return true;
    }

    @Override
    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("file.txt");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Parser.Builder {
        public Builder() {
            super(PlainText.class);
        }

        @Override
        public Parser<?> build() {
            return new PlainTextParser();
        }

        @Override
        public String getDslName() {
            return "text";
        }
    }
}

