/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.table;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

@JsonIgnoreType
public class RewriteRecipeSource
extends DataTable<Row> {
    public RewriteRecipeSource(Recipe recipe) {
        super(recipe, Row.class, RewriteRecipeSource.class.getName(), "Rewrite recipe source code", "This table contains the source code of recipes along with their metadata for use in an experiment fine-tuning large language models to produce more recipes.");
    }

    public static final class Row {
        @Column(displayName="Recipe name", description="The name of the recipe.")
        private final String displayName;
        @Column(displayName="Recipe description", description="The description of the recipe.")
        private final String description;
        @Column(displayName="Recipe type", description="Differentiate between Java and YAML recipes, as they may be two independent data sets used in LLM fine-tuning.")
        private final RecipeType recipeType;
        @Column(displayName="Recipe source code", description="The full source code of the recipe.")
        private final String sourceCode;

        public Row(String displayName, String description, RecipeType recipeType, String sourceCode) {
            this.displayName = displayName;
            this.description = description;
            this.recipeType = recipeType;
            this.sourceCode = sourceCode;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDescription() {
            return this.description;
        }

        public RecipeType getRecipeType() {
            return this.recipeType;
        }

        public String getSourceCode() {
            return this.sourceCode;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            String this$displayName = this.getDisplayName();
            String other$displayName = other.getDisplayName();
            if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            RecipeType this$recipeType = this.getRecipeType();
            RecipeType other$recipeType = other.getRecipeType();
            if (this$recipeType == null ? other$recipeType != null : !((Object)((Object)this$recipeType)).equals((Object)other$recipeType)) {
                return false;
            }
            String this$sourceCode = this.getSourceCode();
            String other$sourceCode = other.getSourceCode();
            return !(this$sourceCode == null ? other$sourceCode != null : !this$sourceCode.equals(other$sourceCode));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            RecipeType $recipeType = this.getRecipeType();
            result = result * 59 + ($recipeType == null ? 43 : ((Object)((Object)$recipeType)).hashCode());
            String $sourceCode = this.getSourceCode();
            result = result * 59 + ($sourceCode == null ? 43 : $sourceCode.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "RewriteRecipeSource.Row(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", recipeType=" + (Object)((Object)this.getRecipeType()) + ", sourceCode=" + this.getSourceCode() + ")";
        }
    }

    public static enum RecipeType {
        Java,
        Yaml;

    }
}

