/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;

@Incubating(since="7.20.0")
public interface TreeObserver {
    default public Tree treeChanged(Cursor cursor, Tree newTree) {
        return newTree;
    }

    default public Tree propertyChanged(String property, Cursor cursor, Tree newTree, Object oldValue, Object newValue) {
        return newTree;
    }

    public static final class Subscription {
        private final TreeObserver observer;
        private final List<Predicate<Tree>> predicates = new ArrayList<Predicate<Tree>>();

        public Subscription(TreeObserver observer) {
            this.observer = observer;
        }

        public Subscription subscribe(@Nullable Tree tree) {
            if (tree != null) {
                this.predicates.add(t -> t == tree);
            }
            return this;
        }

        public Subscription subscribeAll() {
            this.predicates.clear();
            this.predicates.add(t -> true);
            return this;
        }

        public Subscription subscribeAll(Tree tree) {
            new TreeVisitor<Tree, Integer>(){

                @Override
                public Tree visit(@Nullable Tree tree, Integer p) {
                    if (tree != null) {
                        this.subscribe(tree);
                    }
                    return super.visit(tree, p);
                }
            }.visit(tree, (Integer)0);
            return this;
        }

        public Subscription subscribeToType(Class<? extends Tree> treeType) {
            return this.subscribe((Tree t) -> treeType.isAssignableFrom(t.getClass()));
        }

        public Subscription subscribe(Predicate<Tree> predicate) {
            this.predicates.add(predicate);
            return this;
        }

        public boolean isSubscribed(@Nullable Tree tree) {
            if (tree == null) {
                return false;
            }
            for (Predicate<Tree> predicate : this.predicates) {
                if (!predicate.test(tree)) continue;
                return true;
            }
            return false;
        }

        public TreeObserver getObserver() {
            return this.observer;
        }
    }
}

