/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.binary;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Tree;
import org.openrewrite.binary.Binary;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.tree.ParsingExecutionContextView;

public class BinaryParser
implements Parser<Binary> {
    @Override
    public List<Binary> parseInputs(Iterable<Parser.Input> sources, @Nullable Path relativeTo, ExecutionContext ctx) {
        ArrayList<Binary> binaries = new ArrayList<Binary>();
        for (Parser.Input source : sources) {
            Path path = source.getRelativePath(relativeTo);
            try {
                binaries.add(new Binary(Tree.randomId(), path, Markers.EMPTY, source.getFileAttributes(), null, this.readAllBytes(source.getSource(ctx))));
            }
            catch (Exception e) {
                ParsingExecutionContextView.view(ctx).parseFailure(path, this, e);
                ctx.getOnError().accept(e);
            }
        }
        return binaries;
    }

    @Override
    public boolean accept(Path path) {
        return true;
    }

    @Override
    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("file");
    }

    private byte[] readAllBytes(InputStream is) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[4096];
        try {
            int byteCount;
            while ((byteCount = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, byteCount);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer.toByteArray();
    }
}

