/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.function.UnaryOperator;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;

public class PrintOutputCapture<P>
implements Cloneable {
    private final P p;
    private final MarkerPrinter markerPrinter;
    public final StringBuilder out = new StringBuilder();

    public PrintOutputCapture(P p) {
        this.p = p;
        this.markerPrinter = MarkerPrinter.DEFAULT;
    }

    public PrintOutputCapture(P p, MarkerPrinter markerPrinter) {
        this.p = p;
        this.markerPrinter = markerPrinter;
    }

    public P getContext() {
        return this.p;
    }

    public MarkerPrinter getMarkerPrinter() {
        return this.markerPrinter;
    }

    public String getOut() {
        return this.out.toString();
    }

    public PrintOutputCapture<P> append(@Nullable String text) {
        if (text == null) {
            return this;
        }
        this.out.append(text);
        return this;
    }

    public PrintOutputCapture<P> append(char c) {
        this.out.append(c);
        return this;
    }

    public PrintOutputCapture<P> clone() {
        return new PrintOutputCapture<P>(this.p, this.markerPrinter);
    }

    @Incubating(since="7.31.0")
    public static interface MarkerPrinter {
        public static final MarkerPrinter DEFAULT = new MarkerPrinter(){

            @Override
            public String beforeSyntax(Marker marker, Cursor cursor, UnaryOperator<String> commentWrapper) {
                return marker.print(cursor, commentWrapper, false);
            }
        };
        public static final MarkerPrinter VERBOSE = new MarkerPrinter(){

            @Override
            public String beforeSyntax(Marker marker, Cursor cursor, UnaryOperator<String> commentWrapper) {
                return marker.print(cursor, commentWrapper, true);
            }
        };

        default public String beforePrefix(Marker marker, Cursor cursor, UnaryOperator<String> commentWrapper) {
            return "";
        }

        default public String beforeSyntax(Marker marker, Cursor cursor, UnaryOperator<String> commentWrapper) {
            return "";
        }

        default public String afterSyntax(Marker marker, Cursor cursor, UnaryOperator<String> commentWrapper) {
            return "";
        }
    }
}

