/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.text;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Tree;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.text.PlainText;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;

public class PlainTextParser
implements Parser<PlainText> {
    @Override
    public List<PlainText> parseInputs(Iterable<Parser.Input> sources, @Nullable Path relativeTo, ExecutionContext ctx) {
        ArrayList<PlainText> plainTexts = new ArrayList<PlainText>();
        ParsingEventListener parsingListener = ParsingExecutionContextView.view(ctx).getParsingListener();
        for (Parser.Input source : sources) {
            Path path = source.getRelativePath(relativeTo);
            try {
                EncodingDetectingInputStream is = source.getSource(ctx);
                PlainText plainText = new PlainText(Tree.randomId(), path, Markers.EMPTY, is.getCharset().name(), is.isCharsetBomMarked(), source.getFileAttributes(), null, is.readFully());
                plainTexts.add(plainText);
                parsingListener.parsed(source, plainText);
            }
            catch (Throwable t) {
                ParsingExecutionContextView.view(ctx).parseFailure(path, t);
                ctx.getOnError().accept(t);
            }
        }
        return plainTexts;
    }

    @Override
    public boolean accept(Path path) {
        return true;
    }

    @Override
    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("file.txt");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Parser.Builder {
        public Builder() {
            super(PlainText.class);
        }

        @Override
        public Parser<?> build() {
            return new PlainTextParser();
        }

        @Override
        public String getDslName() {
            return "text";
        }
    }
}

