/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marker;

import java.util.UUID;
import org.openrewrite.Incubating;
import org.openrewrite.RecipeRunException;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.SearchResult;

@Incubating(since="7.31.0")
public abstract class Markup
extends SearchResult {
    @Nullable
    private final String detail;
    private final Level level;

    public Markup(UUID id, Level level, String message, @Nullable String detail) {
        super(id, message + (detail != null ? "\n" + detail : ""));
        this.level = level;
        this.detail = detail;
    }

    public static <T extends Tree> T error(T t, String message, Throwable throwable) {
        return Markup.markup(t, Level.ERROR, message, throwable);
    }

    public static <T extends Tree> T warn(T t, String message, Throwable throwable) {
        return Markup.markup(t, Level.WARNING, message, throwable);
    }

    public static <T extends Tree> T info(T t, String message) {
        return Markup.markup(t, Level.INFO, message, null);
    }

    public static <T extends Tree> T debug(T t, String message) {
        return Markup.markup(t, Level.DEBUG, message, null);
    }

    public static <T extends Tree> T markup(T t, Level level, String message) {
        return Markup.markup(t, level, message, null);
    }

    public static <T extends Tree> T markup(T t, Level level, String message, @Nullable Throwable throwable) {
        Markup markup;
        RecipeRunException rre = null;
        if (throwable instanceof RecipeRunException) {
            rre = (RecipeRunException)throwable;
        } else if (throwable != null) {
            rre = new RecipeRunException(throwable);
        }
        switch (level) {
            case DEBUG: {
                markup = new Debug(Tree.randomId(), message);
                break;
            }
            case INFO: {
                markup = new Info(Tree.randomId(), message);
                break;
            }
            case WARNING: {
                markup = new Warn(Tree.randomId(), message, rre);
                break;
            }
            default: {
                markup = new Error(Tree.randomId(), message, rre);
            }
        }
        return t.withMarkers(t.getMarkers().computeByType(markup, (s1, s2) -> s1 == null ? s2 : s1));
    }

    @Nullable
    public String getDetail() {
        return this.detail;
    }

    public Level getLevel() {
        return this.level;
    }

    public static enum Level {
        DEBUG,
        INFO,
        WARNING,
        ERROR;

    }

    public static class Debug
    extends Markup {
        public Debug(UUID id, String message) {
            super(id, Level.DEBUG, message, null);
        }
    }

    public static class Info
    extends Markup {
        public Info(UUID id, String message) {
            super(id, Level.INFO, message, null);
        }
    }

    public static class Warn
    extends Markup {
        @Nullable
        private final RecipeRunException exception;

        public Warn(UUID id, String message, @Nullable RecipeRunException exception) {
            super(id, Level.WARNING, message, exception == null ? null : exception.getSanitizedStackTrace());
            this.exception = exception;
        }

        @Nullable
        public RecipeRunException getException() {
            return this.exception;
        }
    }

    public static class Error
    extends Markup {
        @Nullable
        private final RecipeRunException exception;

        public Error(UUID id, String message, @Nullable RecipeRunException exception) {
            super(id, Level.ERROR, message, exception == null ? null : exception.getSanitizedStackTrace());
            this.exception = exception;
        }

        @Nullable
        public RecipeRunException getException() {
            return this.exception;
        }
    }
}

