/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.ParseExceptionResult;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markup;

public final class FindParseFailures
extends Recipe {
    @Override
    public String getDisplayName() {
        return "Find source files with `ParseExceptionResult` markers";
    }

    @Override
    public String getDescription() {
        return "Find source files with `ParseExceptionResult` markers.";
    }

    @Override
    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            @Nullable
            public Tree visitSourceFile(SourceFile sourceFile, ExecutionContext executionContext) {
                Optional<ParseExceptionResult> parseExceptionResult = sourceFile.getMarkers().findFirst(ParseExceptionResult.class);
                if (parseExceptionResult.isPresent()) {
                    return Markup.error(sourceFile, parseExceptionResult.get().getMessage(), null);
                }
                return sourceFile;
            }
        };
    }

    @NonNull
    public String toString() {
        return "FindParseFailures()";
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindParseFailures)) {
            return false;
        }
        FindParseFailures other = (FindParseFailures)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindParseFailures;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

