/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marker;

import java.util.UUID;
import java.util.function.UnaryOperator;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;

public class SearchResult
implements Marker {
    private final UUID id;
    @Nullable
    private final String description;

    public static <T extends Tree> T found(@Nullable T t) {
        return SearchResult.found(t, null);
    }

    public static <T extends Tree> T found(@Nullable T t, @Nullable String description) {
        if (t == null) {
            return null;
        }
        return t.withMarkers(t.getMarkers().computeByType(new SearchResult(Tree.randomId(), description), (s1, s2) -> s1 == null ? s2 : s1));
    }

    @Override
    public String print(Cursor cursor, UnaryOperator<String> commentWrapper) {
        return (String)commentWrapper.apply(this.description == null ? "" : "(" + this.description + ")");
    }

    public SearchResult(UUID id, @Nullable String description) {
        this.id = id;
        this.description = description;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @NonNull
    public SearchResult withId(UUID id) {
        return this.id == id ? this : new SearchResult(id, this.description);
    }

    @NonNull
    public SearchResult withDescription(@Nullable String description) {
        return this.description == description ? this : new SearchResult(this.id, description);
    }
}

