/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import de.danielbechler.diff.ObjectDifferBuilder;
import de.danielbechler.diff.node.DiffNode;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeRunException;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeObserver;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.TreeVisitorAdapter;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public abstract class TreeVisitor<T extends Tree, P> {
    private static final Cursor ROOT = new Cursor(null, "root");
    private Cursor cursor = ROOT;
    private List<TreeVisitor<T, P>> afterVisit;
    private int visitCount;
    private final DistributionSummary visitCountSummary = DistributionSummary.builder((String)"rewrite.visitor.visit.method.count").description("Visit methods called per source file visited.").tag("visitor.class", this.getClass().getName()).register((MeterRegistry)Metrics.globalRegistry);

    public static <T extends Tree, P> TreeVisitor<T, P> noop() {
        return new TreeVisitor<T, P>(){

            @Override
            @Nullable
            public T visit(@Nullable Tree tree, P p) {
                return tree;
            }

            @Override
            @Nullable
            public T visit(@Nullable Tree tree, P p, Cursor parent) {
                return tree;
            }
        };
    }

    public boolean isAcceptable(SourceFile sourceFile, P p) {
        return true;
    }

    public void setCursor(@Nullable Cursor cursor) {
        this.cursor = cursor;
    }

    @Nullable
    public String getLanguage() {
        return null;
    }

    protected void doAfterVisit(TreeVisitor<T, P> visitor) {
        this.afterVisit.add(visitor);
    }

    @Incubating(since="7.0.0")
    protected void doAfterVisit(Recipe recipe) {
        this.afterVisit.add(recipe.getVisitor());
    }

    protected List<TreeVisitor<T, P>> getAfterVisit() {
        return this.afterVisit;
    }

    public final Cursor getCursor() {
        return this.cursor;
    }

    @Nullable
    public T preVisit(T tree, P p) {
        return this.defaultValue((Tree)tree, p);
    }

    @Nullable
    public T postVisit(T tree, P p) {
        return this.defaultValue((Tree)tree, p);
    }

    @Nullable
    public T visit(@Nullable Tree tree, P p, Cursor parent) {
        this.cursor = parent;
        return this.visit(tree, p);
    }

    @Nullable
    public T visitSourceFile(SourceFile sourceFile, P p) {
        return (T)sourceFile;
    }

    public T visitNonNull(Tree tree, P p) {
        T t = this.visit(tree, p);
        assert (t != null);
        return t;
    }

    public T visitNonNull(Tree tree, P p, Cursor parent) {
        T t = this.visit(tree, p, parent);
        assert (t != null);
        return t;
    }

    @Nullable
    public T visit(@Nullable Tree tree, P p) {
        if (tree == null) {
            return this.defaultValue(null, p);
        }
        Timer.Sample sample = null;
        boolean topLevel = false;
        if (this.afterVisit == null) {
            topLevel = true;
            this.visitCount = 0;
            sample = Timer.start();
            if (p instanceof ExecutionContext) {
                this.cursor.putMessage("org.openrewrite.ExecutionContext", p);
            }
            this.afterVisit = new CopyOnWriteArrayList<TreeVisitor<T, P>>();
        }
        ++this.visitCount;
        this.setCursor(new Cursor(this.cursor, tree));
        Tree t = null;
        boolean isAcceptable = tree.isAcceptable(this, p) && (!(tree instanceof SourceFile) || this.isAcceptable((SourceFile)tree, p));
        try {
            if (isAcceptable) {
                t = this.preVisit(tree, p);
                if (t != null) {
                    t = t.accept(this, p);
                }
                if (t != null) {
                    t = this.postVisit(t, p);
                }
                if (t != tree && t != null && p instanceof ExecutionContext) {
                    ExecutionContext ctx = (ExecutionContext)p;
                    for (TreeObserver.Subscription observer : ctx.getObservers()) {
                        if (!observer.isSubscribed(tree)) continue;
                        observer.getObserver().treeChanged(this.getCursor(), t);
                        AtomicReference<Tree> t2 = new AtomicReference<Tree>(t);
                        DiffNode diff = ObjectDifferBuilder.buildDefault().compare((Object)t, (Object)tree);
                        diff.visit((node, visit) -> {
                            if (!node.hasChildren() && node.getPropertyName() != null) {
                                t2.set(observer.getObserver().propertyChanged(node.getPropertyName(), this.getCursor(), (Tree)t2.get(), node.canonicalGet((Object)tree), node.canonicalGet(t2.get())));
                            }
                        });
                        t = t2.get();
                    }
                }
            }
            this.setCursor(this.cursor.getParent());
            if (topLevel) {
                sample.stop(Timer.builder((String)"rewrite.visitor.visit").tag("visitor.class", this.getClass().getName()).register((MeterRegistry)Metrics.globalRegistry));
                this.visitCountSummary.record((double)this.visitCount);
                if (t != null) {
                    for (TreeVisitor treeVisitor : this.afterVisit) {
                        if (treeVisitor == null) continue;
                        treeVisitor.setCursor(this.getCursor());
                        t = treeVisitor.visit(t, p);
                    }
                }
                sample.stop(Timer.builder((String)"rewrite.visitor.visit.cumulative").tag("visitor.class", this.getClass().getName()).register((MeterRegistry)Metrics.globalRegistry));
                this.afterVisit = null;
            }
        }
        catch (Throwable e) {
            if (e instanceof RecipeRunException) {
                throw e;
            }
            throw new RecipeRunException(e, this.getCursor());
        }
        return (T)(isAcceptable ? t : tree);
    }

    public void visit(@Nullable List<? extends T> nodes, P p) {
        if (nodes != null) {
            for (Tree node : nodes) {
                this.visit(node, p);
            }
        }
    }

    @Nullable
    public T defaultValue(@Nullable Tree tree, P p) {
        return (T)tree;
    }

    @Incubating(since="7.0.0")
    protected final <T2 extends Tree> T2 visitAndCast(T2 t, P p, BiFunction<T2, P, Tree> callSuper) {
        return (T2)callSuper.apply(t, p);
    }

    @Nullable
    @Incubating(since="7.0.0")
    protected final <T2 extends T> T2 visitAndCast(@Nullable Tree tree, P p) {
        return (T2)this.visit(tree, p);
    }

    @Incubating(since="7.2.0")
    public Markers visitMarkers(Markers markers, P p) {
        return markers.withMarkers(ListUtils.map(markers.getMarkers(), marker -> this.visitMarker((Marker)marker, p)));
    }

    @Incubating(since="7.2.0")
    public <M extends Marker> M visitMarker(Marker marker, P p) {
        return (M)marker;
    }

    public boolean isAdaptableTo(Class<? extends TreeVisitor> adaptTo) {
        Class<Tree> mine = this.visitorTreeType(this.getClass());
        Class<Tree> theirs = this.visitorTreeType(adaptTo);
        return mine.isAssignableFrom(theirs);
    }

    private Class<? extends Tree> visitorTreeType(Class<? extends TreeVisitor> v) {
        for (TypeVariable<Class<? extends TreeVisitor>> tp : v.getTypeParameters()) {
            for (Type bound : tp.getBounds()) {
                if (!(bound instanceof Class) || !Tree.class.isAssignableFrom((Class)bound)) continue;
                return (Class)bound;
            }
        }
        Type sup = v.getGenericSuperclass();
        for (int i = 0; i < 20; ++i) {
            if (sup instanceof ParameterizedType) {
                for (Type bound : ((ParameterizedType)sup).getActualTypeArguments()) {
                    if (!(bound instanceof Class) || !Tree.class.isAssignableFrom((Class)bound)) continue;
                    return (Class)bound;
                }
                sup = ((ParameterizedType)sup).getRawType();
                continue;
            }
            if (!(sup instanceof Class)) continue;
            sup = ((Class)sup).getGenericSuperclass();
        }
        throw new IllegalArgumentException("Expected to find a tree type somewhere in the type parameters of the type hierarhcy of visitor " + this.getClass().getName());
    }

    public <R extends Tree, V extends TreeVisitor<R, P>> V adapt(Class<? extends V> adaptTo) {
        if (adaptTo.isAssignableFrom(this.getClass())) {
            return (V)this;
        }
        if (!this.isAdaptableTo(adaptTo)) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " must be adaptable to " + adaptTo.getName() + ".");
        }
        return (V)((TreeVisitor)TreeVisitorAdapter.adapt(this, adaptTo));
    }
}

