/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.ParseExceptionResult;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.quark.Quark;

public final class FindQuarks
extends Recipe {
    @Option(displayName="Include all Quarks", description="Flag to include all instances of type `Quark`, instead of only those with parser failures. Defaults to false.", required=false)
    @Nullable
    private final Boolean includeAll;

    @Override
    public String getDisplayName() {
        return "Find instances of type `Quark`";
    }

    @Override
    public String getDescription() {
        return "Find instances of type `Quark`.";
    }

    @Override
    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree visitSourceFile(SourceFile sourceFile, ExecutionContext executionContext) {
                if (sourceFile instanceof Quark && (FindQuarks.this.includeAll != null && FindQuarks.this.includeAll.booleanValue() || sourceFile.getMarkers().findFirst(ParseExceptionResult.class).isPresent())) {
                    return sourceFile.withMarkers(sourceFile.getMarkers().searchResult());
                }
                return sourceFile;
            }
        };
    }

    public FindQuarks(@Nullable Boolean includeAll) {
        this.includeAll = includeAll;
    }

    @Nullable
    public Boolean getIncludeAll() {
        return this.includeAll;
    }

    @NonNull
    public String toString() {
        return "FindQuarks(includeAll=" + this.getIncludeAll() + ")";
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindQuarks)) {
            return false;
        }
        FindQuarks other = (FindQuarks)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$includeAll = this.getIncludeAll();
        Boolean other$includeAll = other.getIncludeAll();
        return !(this$includeAll == null ? other$includeAll != null : !((Object)this$includeAll).equals(other$includeAll));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindQuarks;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $includeAll = this.getIncludeAll();
        result = result * 59 + ($includeAll == null ? 43 : ((Object)$includeAll).hashCode());
        return result;
    }
}

