/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openrewrite.RecipeRunException;
import org.openrewrite.RecipeRunExceptionResult;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.marker.Marker;

public class FindRecipeRunException
extends TreeVisitor<Tree, Integer> {
    private static final TreeVisitor<Tree, AtomicBoolean> hasRecipeRunExceptionVisitor = new TreeVisitor<Tree, AtomicBoolean>(){

        @Override
        public <M extends Marker> M visitMarker(Marker marker, AtomicBoolean atomicBoolean) {
            if (marker instanceof RecipeRunExceptionResult) {
                atomicBoolean.set(true);
            }
            return super.visitMarker(marker, atomicBoolean);
        }
    };
    private final RecipeRunException vt;
    private final Tree nearestTree;

    public FindRecipeRunException(RecipeRunException rre) {
        this.vt = rre;
        this.nearestTree = (Tree)Objects.requireNonNull(rre.getCursor()).getPath(Tree.class::isInstance).next();
    }

    @Override
    public Tree preVisit(Tree tree, Integer integer) {
        if (tree == this.nearestTree) {
            return tree.withException(this.vt, null);
        }
        return tree;
    }

    public static boolean hasRecipeRunException(Tree tree) {
        AtomicBoolean hasException = new AtomicBoolean(false);
        hasRecipeRunExceptionVisitor.visit(tree, hasException);
        return hasException.get();
    }
}

