/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeRunException;
import org.openrewrite.RecipeRunExceptionResult;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.shaded.jgit.diff.DiffEntry;
import org.openrewrite.shaded.jgit.diff.DiffFormatter;
import org.openrewrite.shaded.jgit.internal.storage.dfs.DfsRepositoryDescription;
import org.openrewrite.shaded.jgit.internal.storage.dfs.InMemoryRepository;
import org.openrewrite.shaded.jgit.lib.AbbreviatedObjectId;
import org.openrewrite.shaded.jgit.lib.FileMode;
import org.openrewrite.shaded.jgit.lib.ObjectId;
import org.openrewrite.shaded.jgit.lib.ObjectInserter;

public class Result {
    @Nullable
    private final SourceFile before;
    @Nullable
    private final SourceFile after;
    private final Collection<Stack<Recipe>> recipes;
    @Nullable
    private final Duration timeSavings;
    @Nullable
    private transient WeakReference<String> diff;
    @Nullable
    private Path relativeTo;

    public List<RecipeRunException> getRecipeErrors() {
        final ArrayList<RecipeRunException> exceptions = new ArrayList<RecipeRunException>();
        new TreeVisitor<Tree, Integer>(){

            @Override
            @Nullable
            public Tree visit(@Nullable Tree tree, Integer p) {
                if (tree != null) {
                    try {
                        Method getMarkers = tree.getClass().getDeclaredMethod("getMarkers", new Class[0]);
                        Markers markers = (Markers)getMarkers.invoke((Object)tree, new Object[0]);
                        markers.findFirst(RecipeRunExceptionResult.class).ifPresent(e -> exceptions.add(e.getException()));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return super.visit(tree, p);
            }
        }.visit((Tree)this.after, (Integer)0);
        return exceptions;
    }

    @Deprecated
    public Set<Recipe> getRecipesThatMadeChanges() {
        return this.recipes.stream().map(Stack::peek).collect(Collectors.toSet());
    }

    public List<RecipeDescriptor> getRecipeDescriptorsThatMadeChanges() {
        ArrayList<RecipeDescriptor> recipesToDisplay = new ArrayList<RecipeDescriptor>();
        for (Stack<Recipe> currentStack : this.recipes) {
            RecipeDescriptor index;
            Recipe root = currentStack.size() > 1 ? (Recipe)currentStack.get(1) : (Recipe)currentStack.get(0);
            RecipeDescriptor rootDescriptor = root.getDescriptor().withRecipeList(new ArrayList<RecipeDescriptor>());
            if (recipesToDisplay.contains(rootDescriptor)) {
                index = (RecipeDescriptor)recipesToDisplay.get(recipesToDisplay.indexOf(rootDescriptor));
            } else {
                recipesToDisplay.add(rootDescriptor);
                index = rootDescriptor;
            }
            for (int i = 2; i < currentStack.size(); ++i) {
                RecipeDescriptor nextDescriptor = ((Recipe)currentStack.get(i)).getDescriptor().withRecipeList(new ArrayList<RecipeDescriptor>());
                if (index.getRecipeList().contains(nextDescriptor)) {
                    index = index.getRecipeList().get(index.getRecipeList().indexOf(nextDescriptor));
                    continue;
                }
                index.getRecipeList().add(nextDescriptor);
                index = nextDescriptor;
            }
        }
        return recipesToDisplay;
    }

    public Result(@Nullable SourceFile before, @Nullable SourceFile after, Collection<Stack<Recipe>> recipes) {
        this.before = before;
        this.after = after;
        this.recipes = recipes;
        Duration timeSavings = null;
        for (Stack<Recipe> recipesStack : recipes) {
            Duration perOccurrence;
            if (recipesStack == null || (perOccurrence = recipesStack.peek().getEstimatedEffortPerOccurrence()) == null) continue;
            timeSavings = timeSavings == null ? perOccurrence : timeSavings.plus(perOccurrence);
        }
        this.timeSavings = timeSavings;
    }

    public String diff() {
        return this.diff(null);
    }

    public String diff(@Nullable Path relativeTo) {
        String d;
        if (this.diff == null) {
            d = this.computeDiff(relativeTo);
            this.diff = new WeakReference<String>(d);
        } else {
            d = (String)this.diff.get();
            if (d == null || !Objects.equals(this.relativeTo, relativeTo)) {
                d = this.computeDiff(relativeTo);
                this.diff = new WeakReference<String>(d);
            }
        }
        return d;
    }

    private String computeDiff(@Nullable Path relativeTo) {
        Path beforePath = this.before == null ? null : this.before.getSourcePath();
        Path afterPath = null;
        if (this.before == null && this.after == null) {
            afterPath = (relativeTo == null ? Paths.get(".", new String[0]) : relativeTo).resolve("partial-" + System.nanoTime());
        } else if (this.after != null) {
            afterPath = this.after.getSourcePath();
        }
        try (InMemoryDiffEntry diffEntry = new InMemoryDiffEntry(beforePath, afterPath, relativeTo, this.before == null ? "" : this.before.printAll(), this.after == null ? "" : this.after.printAll(), this.recipes.stream().map(Stack::peek).collect(Collectors.toSet()));){
            this.relativeTo = relativeTo;
            String string = diffEntry.getDiff();
            return string;
        }
    }

    public String toString() {
        return this.diff();
    }

    @Nullable
    public SourceFile getBefore() {
        return this.before;
    }

    @Nullable
    public SourceFile getAfter() {
        return this.after;
    }

    public Collection<Stack<Recipe>> getRecipes() {
        return this.recipes;
    }

    @Nullable
    public Duration getTimeSavings() {
        return this.timeSavings;
    }

    static class InMemoryDiffEntry
    extends DiffEntry
    implements AutoCloseable {
        static final AbbreviatedObjectId A_ZERO = AbbreviatedObjectId.fromObjectId(ObjectId.zeroId());
        private final InMemoryRepository repo;
        private final Set<Recipe> recipesThatMadeChanges;

        InMemoryDiffEntry(@Nullable Path originalFilePath, @Nullable Path filePath, @Nullable Path relativeTo, String oldSource, String newSource, Set<Recipe> recipesThatMadeChanges) {
            this.recipesThatMadeChanges = recipesThatMadeChanges;
            try {
                this.repo = ((InMemoryRepository.Builder)new InMemoryRepository.Builder().setRepositoryDescription(new DfsRepositoryDescription())).build();
                try (ObjectInserter inserter = this.repo.getObjectDatabase().newInserter();){
                    if (originalFilePath != null) {
                        this.oldId = inserter.insert(3, oldSource.getBytes(StandardCharsets.UTF_8)).abbreviate(40);
                        this.oldMode = FileMode.REGULAR_FILE;
                        this.oldPath = (relativeTo == null ? originalFilePath : relativeTo.relativize(originalFilePath)).toString().replace("\\", "/");
                    } else {
                        this.oldId = A_ZERO;
                        this.oldMode = FileMode.MISSING;
                        this.oldPath = "/dev/null";
                    }
                    if (filePath != null) {
                        this.newId = inserter.insert(3, newSource.getBytes(StandardCharsets.UTF_8)).abbreviate(40);
                        this.newMode = FileMode.REGULAR_FILE;
                        this.newPath = (relativeTo == null ? filePath : relativeTo.relativize(filePath)).toString().replace("\\", "/");
                    } else {
                        this.newId = A_ZERO;
                        this.newMode = FileMode.MISSING;
                        this.newPath = "/dev/null";
                    }
                    inserter.flush();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            this.changeType = this.oldMode == FileMode.MISSING && this.newMode != FileMode.MISSING ? DiffEntry.ChangeType.ADD : (this.oldMode != FileMode.MISSING && this.newMode == FileMode.MISSING ? DiffEntry.ChangeType.DELETE : (!this.oldPath.equals(this.newPath) ? DiffEntry.ChangeType.RENAME : DiffEntry.ChangeType.MODIFY));
        }

        String getDiff() {
            if (this.oldId.equals(this.newId) && this.oldPath.equals(this.newPath)) {
                return "";
            }
            ByteArrayOutputStream patch = new ByteArrayOutputStream();
            try (DiffFormatter formatter = new DiffFormatter(patch);){
                formatter.setRepository(this.repo);
                formatter.format(this);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            String diff = patch.toString();
            AtomicBoolean addedComment = new AtomicBoolean(false);
            return Arrays.stream(diff.split("\n")).map(l -> {
                if (!addedComment.get() && l.startsWith("@@") && l.endsWith("@@")) {
                    addedComment.set(true);
                    LinkedHashSet<String> sortedRecipeNames = new LinkedHashSet<String>();
                    for (Recipe recipesThatMadeChange : this.recipesThatMadeChanges) {
                        sortedRecipeNames.add(recipesThatMadeChange.getName());
                    }
                    StringJoiner joinedRecipeNames = new StringJoiner(", ", " ", "");
                    for (String name : sortedRecipeNames) {
                        joinedRecipeNames.add(name);
                    }
                    return l + joinedRecipeNames;
                }
                return l;
            }).collect(Collectors.joining("\n")) + "\n";
        }

        @Override
        public void close() {
            this.repo.close();
        }
    }
}

