/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.UUID;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeRunException;
import org.openrewrite.RecipeRunExceptionResult;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.FindRecipeRunException;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.marker.RecipesThatMadeChanges;
import org.openrewrite.text.PlainTextParser;

class RecipeSchedulerUtils {
    RecipeSchedulerUtils() {
    }

    public static <S extends SourceFile> S addRecipesThatMadeChanges(Stack<Recipe> recipeStack, S afterFile) {
        ArrayList<Stack<Recipe>> recipeStackList = new ArrayList<Stack<Recipe>>(1);
        recipeStackList.add(recipeStack);
        afterFile = afterFile.withMarkers(afterFile.getMarkers().computeByType(new RecipesThatMadeChanges(Tree.randomId(), recipeStackList), (r1, r2) -> {
            r1.getRecipes().addAll(r2.getRecipes());
            return r1;
        }));
        return afterFile;
    }

    public static <S extends SourceFile> List<S> handleUncaughtException(Stack<Recipe> recipeStack, Map<UUID, Stack<Recipe>> recipeThatAddedOrDeletedSourceFile, List<S> before, ExecutionContext ctx, Recipe recipe, Throwable t) {
        RecipeRunException vt;
        List<S> exceptionMapped;
        ctx.getOnError().accept(t);
        ctx.putMessage("__AHHH_PANIC!!!__", true);
        if (t instanceof RecipeRunException && (exceptionMapped = ListUtils.map(before, arg_0 -> RecipeSchedulerUtils.lambda$handleUncaughtException$1(vt = (RecipeRunException)t, recipeStack, arg_0))) != before) {
            return exceptionMapped;
        }
        Object exception = ((SourceFile)PlainTextParser.builder().build().parse("Rewrite encountered an uncaught recipe error in " + recipe.getName() + ".").get(0)).withSourcePath(Paths.get("recipe-exception-" + ctx.incrementAndGetUncaughtExceptionCount() + ".txt", new String[0]));
        exception = exception.withMarkers(exception.getMarkers().computeByType(new RecipeRunExceptionResult(new RecipeRunException(t)), (acc, m) -> acc));
        recipeThatAddedOrDeletedSourceFile.put(exception.getId(), recipeStack);
        return ListUtils.concat(before, exception);
    }

    private static /* synthetic */ SourceFile lambda$handleUncaughtException$1(RecipeRunException vt, Stack recipeStack, SourceFile sourceFile) {
        SourceFile afterFile = (SourceFile)new FindRecipeRunException(vt).visitNonNull(Objects.requireNonNull(sourceFile), 0);
        if (afterFile != sourceFile) {
            afterFile = RecipeSchedulerUtils.addRecipesThatMadeChanges(recipeStack, afterFile);
        }
        return afterFile;
    }
}

