/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public abstract class TreeVisitor<T extends Tree, P> {
    private static final boolean IS_DEBUGGING = System.getProperty("org.openrewrite.debug") != null || ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;
    private Cursor cursor;
    private List<TreeVisitor<T, P>> afterVisit;

    public TreeVisitor() {
        this.setCursor(new Cursor(null, "root"));
    }

    protected void setCursor(@Nullable Cursor cursor) {
        this.cursor = cursor;
    }

    @Nullable
    public String getLanguage() {
        return null;
    }

    protected void doAfterVisit(TreeVisitor<T, P> visitor) {
        this.afterVisit.add(visitor);
    }

    @Incubating(since="7.0.0")
    protected void doAfterVisit(Recipe recipe) {
        this.afterVisit.add(recipe.getVisitor());
    }

    protected List<TreeVisitor<T, P>> getAfterVisit() {
        return this.afterVisit;
    }

    public final Cursor getCursor() {
        if (this.cursor == null) {
            throw new IllegalStateException("Cursoring is not enabled for this visitor. Call setCursoringOn() in the visitor's constructor to enable.");
        }
        return this.cursor;
    }

    @Nullable
    public T preVisit(T tree, P p) {
        return this.defaultValue((Tree)tree, p);
    }

    @Nullable
    public T postVisit(T tree, P p) {
        return this.defaultValue((Tree)tree, p);
    }

    @Nullable
    public T visit(@Nullable Tree tree, P p, Cursor parent) {
        this.cursor = parent;
        return this.visit(tree, p);
    }

    @Nullable
    public T visit(@Nullable Tree tree, P p) {
        if (tree == null) {
            return this.defaultValue(null, p);
        }
        Timer.Sample sample = null;
        boolean topLevel = false;
        if (this.afterVisit == null) {
            topLevel = true;
            sample = Timer.start();
            this.afterVisit = new ArrayList<TreeVisitor<T, P>>();
        }
        this.setCursor(new Cursor(this.cursor, tree));
        Tree t = null;
        boolean isAcceptable = tree.isAcceptable(this, p);
        if (isAcceptable) {
            t = this.preVisit(tree, p);
            if (t != null) {
                t = t.accept(this, p);
            }
            if (t != null) {
                t = this.postVisit(t, p);
            }
            if (IS_DEBUGGING && t != tree) {
                this.debugOnChange(tree, t);
            }
        }
        this.setCursor(this.cursor.getParent());
        if (topLevel) {
            sample.stop(Timer.builder((String)"rewrite.visitor.visit").tag("visitor.class", this.getClass().getName()).register((MeterRegistry)Metrics.globalRegistry));
            if (t != null) {
                for (TreeVisitor<T, P> v : this.afterVisit) {
                    t = v.visit(t, p);
                }
            }
            sample.stop(Timer.builder((String)"rewrite.visitor.visit.cumulative").tag("visitor.class", this.getClass().getName()).register((MeterRegistry)Metrics.globalRegistry));
            this.afterVisit = null;
        }
        return (T)(isAcceptable ? t : tree);
    }

    @Incubating(since="7.3.0")
    protected void debugOnChange(@Nullable Tree before, @Nullable Tree after) {
    }

    @Nullable
    public T defaultValue(@Nullable Tree tree, P p) {
        return (T)tree;
    }

    @Incubating(since="7.0.0")
    protected final <T2 extends Tree> T2 visitAndCast(T2 t, P p, BiFunction<T2, P, Tree> callSuper) {
        return (T2)callSuper.apply(t, p);
    }

    @Nullable
    @Incubating(since="7.0.0")
    protected final <T2 extends T> T2 visitAndCast(@Nullable Tree tree, P p) {
        return (T2)this.visit(tree, p);
    }

    @Incubating(since="7.2.0")
    public Markers visitMarkers(Markers markers, P p) {
        Collection<? extends Marker> originalMarkers = markers.entries();
        ArrayList visited = new ArrayList(originalMarkers.size());
        boolean anyChanged = false;
        for (Marker marker : originalMarkers) {
            Object visitedMarker = this.visitMarker(marker, p);
            visited.add(visitedMarker);
            anyChanged = anyChanged || visitedMarker != marker;
        }
        if (anyChanged) {
            return Markers.build(visited);
        }
        return markers;
    }

    @Incubating(since="7.2.0")
    public <M extends Marker> M visitMarker(Marker marker, P p) {
        return (M)marker;
    }
}

