/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.openrewrite.ExecutionContext;
import org.openrewrite.internal.lang.Nullable;

public class InMemoryExecutionContext
implements ExecutionContext {
    private final Map<String, Object> messages = new ConcurrentHashMap<String, Object>();
    private final Consumer<Throwable> onError;
    private final Function<Integer, Duration> runTimeout;

    public InMemoryExecutionContext() {
        this(t -> {});
    }

    public InMemoryExecutionContext(Consumer<Throwable> onError) {
        this(onError, n -> Duration.ofHours(2L));
    }

    public InMemoryExecutionContext(Consumer<Throwable> onError, Function<Integer, Duration> runTimeout) {
        this.onError = onError;
        this.runTimeout = runTimeout;
    }

    @Override
    public void putMessage(String key, Object value) {
        this.messages.put(key, value);
    }

    @Override
    @Nullable
    public <T> T getMessage(String key) {
        return (T)this.messages.get(key);
    }

    @Override
    @Nullable
    public <T> T pollMessage(String key) {
        return (T)this.messages.remove(key);
    }

    @Override
    public Consumer<Throwable> getOnError() {
        return this.onError;
    }

    @Override
    public Duration getRunTimeout(int inputs) {
        return this.runTimeout.apply(inputs);
    }
}

