/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.FileAttributes;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;

public interface SourceFile
extends Tree {
    public Path getSourcePath();

    public <T extends SourceFile> T withSourcePath(Path var1);

    @Nullable
    public Charset getCharset();

    public <T extends SourceFile> T withCharset(Charset var1);

    public boolean isCharsetBomMarked();

    public <T extends SourceFile> T withCharsetBomMarked(boolean var1);

    @Nullable
    public Checksum getChecksum();

    public <T extends SourceFile> T withChecksum(@Nullable Checksum var1);

    @Nullable
    public FileAttributes getFileAttributes();

    public <T extends SourceFile> T withFileAttributes(@Nullable FileAttributes var1);

    public Markers getMarkers();

    public <T extends SourceFile> T withMarkers(Markers var1);

    @Nullable
    default public <S extends Style> S getStyle(Class<S> style) {
        return NamedStyles.merge(style, this.getMarkers().findAll(NamedStyles.class));
    }

    default public <P> byte[] printAllAsBytes(P p) {
        return this.printAll(p).getBytes(this.getCharset() == null ? StandardCharsets.UTF_8 : this.getCharset());
    }

    default public byte[] printAllAsBytes() {
        return this.printAllAsBytes(0);
    }

    default public <P> String printAll(P p) {
        return this.print(p, new Cursor(null, this));
    }

    default public String printAll() {
        return this.printAll(0);
    }

    default public <P> String printAllTrimmed(P p) {
        return this.printTrimmed(p, new Cursor(null, this));
    }

    default public String printAllTrimmed() {
        return this.printAllTrimmed(0);
    }

    @Override
    default public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
        throw new UnsupportedOperationException("SourceFile implementations should override this method");
    }

    default public long getWeight(Predicate<Object> uniqueIdentity) {
        final AtomicInteger n = new AtomicInteger();
        new TreeVisitor<Tree, AtomicInteger>(){

            @Override
            @Nullable
            public Tree visit(@Nullable Tree tree, AtomicInteger atomicInteger) {
                if (tree != null) {
                    n.incrementAndGet();
                }
                return super.visit(tree, atomicInteger);
            }
        }.visit((Tree)this, n);
        return n.get();
    }
}

