/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shaded.jgit.treewalk.filter;

import java.io.IOException;
import org.openrewrite.shaded.jgit.errors.IncorrectObjectTypeException;
import org.openrewrite.shaded.jgit.errors.MissingObjectException;
import org.openrewrite.shaded.jgit.internal.JGitText;
import org.openrewrite.shaded.jgit.lib.Constants;
import org.openrewrite.shaded.jgit.treewalk.TreeWalk;
import org.openrewrite.shaded.jgit.treewalk.filter.TreeFilter;

public class PathSuffixFilter
extends TreeFilter {
    final String pathStr;
    final byte[] pathRaw;

    public static PathSuffixFilter create(String path) {
        if (path.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().emptyPathNotPermitted);
        }
        return new PathSuffixFilter(path);
    }

    private PathSuffixFilter(String s) {
        this.pathStr = s;
        this.pathRaw = Constants.encode(this.pathStr);
    }

    @Override
    public TreeFilter clone() {
        return this;
    }

    @Override
    public boolean include(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (walker.isSubtree()) {
            return true;
        }
        return walker.isPathSuffix(this.pathRaw, this.pathRaw.length);
    }

    @Override
    public int matchFilter(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (walker.isSubtree()) {
            return -1;
        }
        return super.matchFilter(walker);
    }

    @Override
    public boolean shouldBeRecursive() {
        return true;
    }
}

