/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import org.openrewrite.Recipe;
import org.openrewrite.config.CategoryDescriptor;
import org.openrewrite.config.DeclarativeRecipe;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.config.RecipeExample;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.internal.RecipeIntrospectionUtils;
import org.openrewrite.style.NamedStyles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathScanningLoader
implements ResourceLoader {
    private static final Logger logger = LoggerFactory.getLogger(ClasspathScanningLoader.class);
    private final List<Recipe> recipes = new ArrayList<Recipe>();
    private final List<NamedStyles> styles = new ArrayList<NamedStyles>();
    private final List<RecipeDescriptor> recipeDescriptors = new ArrayList<RecipeDescriptor>();
    private final List<CategoryDescriptor> categoryDescriptors = new ArrayList<CategoryDescriptor>();
    private final List<RecipeExample> recipeExamples = new ArrayList<RecipeExample>();

    public ClasspathScanningLoader(Properties properties, String[] acceptPackages) {
        this.scanClasses(new ClassGraph().acceptPackages(acceptPackages), this.getClass().getClassLoader());
        this.scanYaml(new ClassGraph().acceptPaths(new String[]{"META-INF/rewrite"}), properties, null);
    }

    public ClasspathScanningLoader(Properties properties, ClassLoader classLoader) {
        this.scanClasses(new ClassGraph().ignoreParentClassLoaders().overrideClassLoaders(new ClassLoader[]{classLoader}), classLoader);
        this.scanYaml(new ClassGraph().ignoreParentClassLoaders().overrideClassLoaders(new ClassLoader[]{classLoader}).acceptPaths(new String[]{"META-INF/rewrite"}), properties, classLoader);
    }

    public ClasspathScanningLoader(Path jar, Properties properties, ClassLoader classLoader) {
        String jarName = jar.toFile().getName();
        this.scanClasses(new ClassGraph().acceptJars(new String[]{jarName}).ignoreParentClassLoaders().overrideClassLoaders(new ClassLoader[]{classLoader}), classLoader);
        this.scanYaml(new ClassGraph().acceptJars(new String[]{jarName}).ignoreParentClassLoaders().overrideClassLoaders(new ClassLoader[]{classLoader}).acceptPaths(new String[]{"META-INF/rewrite"}), properties, classLoader);
    }

    private void scanYaml(ClassGraph classGraph, Properties properties, @Nullable ClassLoader classLoader) {
        try (ScanResult scanResult = classGraph.enableMemoryMapping().scan();){
            ArrayList yamlResourceLoaders = new ArrayList();
            scanResult.getResourcesWithExtension("yml").forEachInputStreamIgnoringIOException((res, input) -> yamlResourceLoaders.add(new YamlResourceLoader(input, res.getURI(), properties, classLoader)));
            for (YamlResourceLoader resourceLoader : yamlResourceLoaders) {
                this.recipes.addAll(resourceLoader.listRecipes());
                this.categoryDescriptors.addAll(resourceLoader.listCategoryDescriptors());
                this.styles.addAll(resourceLoader.listStyles());
                this.recipeExamples.addAll(resourceLoader.listRecipeExamples());
            }
            for (YamlResourceLoader resourceLoader : yamlResourceLoaders) {
                this.recipeDescriptors.addAll(resourceLoader.listRecipeDescriptors(this.recipes));
            }
        }
    }

    private void scanClasses(ClassGraph classGraph, ClassLoader classLoader) {
        try (ScanResult result = classGraph.ignoreClassVisibility().overrideClassLoaders(new ClassLoader[]{classLoader}).scan();){
            for (ClassInfo classInfo : result.getSubclasses(Recipe.class.getName())) {
                Class recipeClass = classInfo.loadClass();
                if (recipeClass.getName().equals(DeclarativeRecipe.class.getName()) || recipeClass.getEnclosingClass() != null) continue;
                try {
                    Recipe recipe = RecipeIntrospectionUtils.constructRecipe(recipeClass);
                    this.recipeDescriptors.add(RecipeIntrospectionUtils.recipeDescriptorFromRecipe(recipe));
                    this.recipes.add(recipe);
                }
                catch (Exception e) {
                    logger.warn("Unable to configure {}", (Object)recipeClass.getName(), (Object)e);
                }
            }
            for (ClassInfo classInfo : result.getSubclasses(NamedStyles.class.getName())) {
                Class styleClass = classInfo.loadClass();
                try {
                    Constructor<?> constructor = RecipeIntrospectionUtils.getZeroArgsConstructor(styleClass);
                    if (constructor == null) continue;
                    constructor.setAccessible(true);
                    this.styles.add((NamedStyles)constructor.newInstance(new Object[0]));
                }
                catch (Exception e) {
                    logger.warn("Unable to configure {}", (Object)styleClass.getName(), (Object)e);
                }
            }
        }
    }

    @Override
    public Collection<Recipe> listRecipes() {
        return this.recipes;
    }

    @Override
    public Collection<RecipeDescriptor> listRecipeDescriptors() {
        return this.recipeDescriptors;
    }

    @Override
    public Collection<CategoryDescriptor> listCategoryDescriptors() {
        return this.categoryDescriptors;
    }

    @Override
    public Collection<NamedStyles> listStyles() {
        return this.styles;
    }

    @Override
    public Collection<RecipeExample> listRecipeExamples() {
        return this.recipeExamples;
    }
}

