/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.StringJoiner;
import java.util.UUID;
import org.openrewrite.Cursor;
import org.openrewrite.RecipeScheduler;

public class UncaughtVisitorException
extends RuntimeException {
    private final UUID id = UUID.randomUUID();
    private final Cursor cursor;

    public UncaughtVisitorException(Throwable cause, Cursor cursor) {
        super(cause);
        this.cursor = cursor;
    }

    public String getSanitizedStackTrace() {
        StringJoiner sanitized = new StringJoiner("\n");
        sanitized.add(this.getCause().getClass().getName() + ": " + this.getCause().getLocalizedMessage());
        int i = 0;
        for (StackTraceElement stackTraceElement : this.getCause().getStackTrace()) {
            if (stackTraceElement.getClassName().equals(RecipeScheduler.class.getName())) break;
            if (i++ >= 8) {
                sanitized.add("  ...");
                break;
            }
            sanitized.add("  " + stackTraceElement);
        }
        return sanitized.toString();
    }

    public UUID getId() {
        return this.id;
    }

    public Cursor getCursor() {
        return this.cursor;
    }
}

