/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.UUID;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.MetricsHelper;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@c")
public interface Tree {
    @JsonProperty(value="@c")
    default public String getJacksonPolymorphicTypeTag() {
        return this.getClass().getName();
    }

    public static UUID randomId() {
        return (UUID)MetricsHelper.UUID_TIMER.record(UUID::randomUUID);
    }

    public UUID getId();

    public <T extends Tree> T withId(UUID var1);

    @Nullable
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return v.defaultValue(this, p);
    }

    public <P> boolean isAcceptable(TreeVisitor<?, P> var1, P var2);

    default public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
        return cursor.firstEnclosingOrThrow(SourceFile.class).printer(cursor);
    }

    default public <P> String print(P p, Cursor cursor) {
        PrintOutputCapture<P> outputCapture = new PrintOutputCapture<P>(p);
        this.printer(cursor).visit(this, outputCapture, cursor);
        return outputCapture.out.toString();
    }

    default public <P> String print(P p, TreeVisitor<?, PrintOutputCapture<P>> printer) {
        PrintOutputCapture<P> outputCapture = new PrintOutputCapture<P>(p);
        printer.visit(this, outputCapture);
        return outputCapture.out.toString();
    }

    default public String print(Cursor cursor) {
        return this.print(Integer.valueOf(0), cursor);
    }

    default public String print(TreeVisitor<?, PrintOutputCapture<Integer>> printer) {
        return this.print(Integer.valueOf(0), printer);
    }

    default public <P> String printTrimmed(P p, Cursor cursor) {
        return StringUtils.trimIndent(this.print(p, cursor));
    }

    default public String printTrimmed(Cursor cursor) {
        return StringUtils.trimIndent(this.print(cursor));
    }

    default public String printTrimmed(TreeVisitor<?, PrintOutputCapture<Integer>> printer) {
        return StringUtils.trimIndent(this.print(printer));
    }

    default public boolean isScope(@Nullable Tree tree) {
        return tree != null && tree.getId().equals(this.getId());
    }

    default public <T2 extends Tree> T2 cast() {
        return (T2)this;
    }

    @Nullable
    default public <T2 extends Tree> T2 safeCast() {
        try {
            return this.cast();
        }
        catch (ClassCastException ignored) {
            return null;
        }
    }
}

