/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shaded.jgit.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.openrewrite.shaded.jgit.api.CloneCommand;
import org.openrewrite.shaded.jgit.api.FetchCommand;
import org.openrewrite.shaded.jgit.api.Git;
import org.openrewrite.shaded.jgit.api.MergeCommand;
import org.openrewrite.shaded.jgit.api.RebaseCommand;
import org.openrewrite.shaded.jgit.api.TransportCommand;
import org.openrewrite.shaded.jgit.api.errors.CheckoutConflictException;
import org.openrewrite.shaded.jgit.api.errors.ConcurrentRefUpdateException;
import org.openrewrite.shaded.jgit.api.errors.GitAPIException;
import org.openrewrite.shaded.jgit.api.errors.InvalidConfigurationException;
import org.openrewrite.shaded.jgit.api.errors.InvalidMergeHeadsException;
import org.openrewrite.shaded.jgit.api.errors.JGitInternalException;
import org.openrewrite.shaded.jgit.api.errors.NoHeadException;
import org.openrewrite.shaded.jgit.api.errors.NoMessageException;
import org.openrewrite.shaded.jgit.api.errors.RefNotFoundException;
import org.openrewrite.shaded.jgit.api.errors.WrongRepositoryStateException;
import org.openrewrite.shaded.jgit.dircache.DirCacheCheckout;
import org.openrewrite.shaded.jgit.errors.ConfigInvalidException;
import org.openrewrite.shaded.jgit.lib.ProgressMonitor;
import org.openrewrite.shaded.jgit.lib.RefUpdate;
import org.openrewrite.shaded.jgit.lib.Repository;
import org.openrewrite.shaded.jgit.merge.MergeStrategy;
import org.openrewrite.shaded.jgit.revwalk.RevCommit;
import org.openrewrite.shaded.jgit.revwalk.RevWalk;
import org.openrewrite.shaded.jgit.submodule.SubmoduleWalk;
import org.openrewrite.shaded.jgit.treewalk.filter.PathFilterGroup;

public class SubmoduleUpdateCommand
extends TransportCommand<SubmoduleUpdateCommand, Collection<String>> {
    private ProgressMonitor monitor;
    private final Collection<String> paths;
    private MergeStrategy strategy = MergeStrategy.RECURSIVE;
    private CloneCommand.Callback callback;
    private FetchCommand.Callback fetchCallback;
    private boolean fetch = false;

    public SubmoduleUpdateCommand(Repository repo) {
        super(repo);
        this.paths = new ArrayList<String>();
    }

    public SubmoduleUpdateCommand setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public SubmoduleUpdateCommand setFetch(boolean fetch) {
        this.fetch = fetch;
        return this;
    }

    public SubmoduleUpdateCommand addPath(String path) {
        this.paths.add(path);
        return this;
    }

    private Repository getOrCloneSubmodule(SubmoduleWalk generator, String url) throws IOException, GitAPIException {
        Repository repository = generator.getRepository();
        if (repository == null) {
            if (this.callback != null) {
                this.callback.cloningSubmodule(generator.getPath());
            }
            CloneCommand clone = Git.cloneRepository();
            this.configure(clone);
            clone.setURI(url);
            clone.setDirectory(generator.getDirectory());
            clone.setGitDir(new File(new File(this.repo.getDirectory(), "modules"), generator.getPath()));
            if (this.monitor != null) {
                clone.setProgressMonitor(this.monitor);
            }
            repository = clone.call().getRepository();
        } else if (this.fetch) {
            if (this.fetchCallback != null) {
                this.fetchCallback.fetchingSubmodule(generator.getPath());
            }
            FetchCommand fetchCommand = Git.wrap(repository).fetch();
            if (this.monitor != null) {
                fetchCommand.setProgressMonitor(this.monitor);
            }
            this.configure(fetchCommand);
            fetchCommand.call();
        }
        return repository;
    }

    @Override
    public Collection<String> call() throws InvalidConfigurationException, NoHeadException, ConcurrentRefUpdateException, CheckoutConflictException, InvalidMergeHeadsException, WrongRepositoryStateException, NoMessageException, NoHeadException, RefNotFoundException, GitAPIException {
        this.checkCallable();
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try (SubmoduleWalk generator = SubmoduleWalk.forIndex(this.repo);){
                if (!this.paths.isEmpty()) {
                    generator.setFilter(PathFilterGroup.createFromStrings(this.paths));
                }
                ArrayList<String> updated = new ArrayList<String>();
                while (generator.next()) {
                    String url;
                    if (generator.getModulesPath() == null || (url = generator.getConfigUrl()) == null) continue;
                    Throwable throwable2 = null;
                    Object var7_12 = null;
                    try {
                        Repository submoduleRepo = this.getOrCloneSubmodule(generator, url);
                        try {
                            try (RevWalk walk = new RevWalk(submoduleRepo);){
                                RevCommit commit = walk.parseCommit(generator.getObjectId());
                                String update = generator.getConfigUpdate();
                                if ("merge".equals(update)) {
                                    MergeCommand merge = new MergeCommand(submoduleRepo);
                                    merge.include(commit);
                                    merge.setProgressMonitor(this.monitor);
                                    merge.setStrategy(this.strategy);
                                    merge.call();
                                } else if ("rebase".equals(update)) {
                                    RebaseCommand rebase = new RebaseCommand(submoduleRepo);
                                    rebase.setUpstream(commit);
                                    rebase.setProgressMonitor(this.monitor);
                                    rebase.setStrategy(this.strategy);
                                    rebase.call();
                                } else {
                                    DirCacheCheckout co = new DirCacheCheckout(submoduleRepo, submoduleRepo.lockDirCache(), commit.getTree());
                                    co.setFailOnConflict(true);
                                    co.setProgressMonitor(this.monitor);
                                    co.checkout();
                                    RefUpdate refUpdate = submoduleRepo.updateRef("HEAD", true);
                                    refUpdate.setNewObjectId(commit);
                                    refUpdate.forceUpdate();
                                    if (this.callback != null) {
                                        this.callback.checkingOut(commit, generator.getPath());
                                    }
                                }
                            }
                            if (submoduleRepo != null) {
                                submoduleRepo.close();
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            if (submoduleRepo != null) {
                                submoduleRepo.close();
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                        } else if (throwable2 != throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        throw throwable2;
                    }
                    updated.add(generator.getPath());
                }
                return updated;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (ConfigInvalidException e) {
            throw new InvalidConfigurationException(e.getMessage(), e);
        }
    }

    public SubmoduleUpdateCommand setStrategy(MergeStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public SubmoduleUpdateCommand setCallback(CloneCommand.Callback callback) {
        this.callback = callback;
        return this;
    }

    public SubmoduleUpdateCommand setFetchCallback(FetchCommand.Callback callback) {
        this.fetchCallback = callback;
        return this;
    }
}

