/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.semver;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.semver.LatestRelease;

public class HyphenRange
extends LatestRelease {
    private static final Pattern HYPHEN_RANGE_PATTERN = Pattern.compile("(\\d+(\\.\\d+)?(\\.\\d+)?(\\.\\d+)?)\\s*-\\s*(\\d+(\\.\\d+)?(\\.\\d+)?(\\.\\d+)?)");
    private final String upper;
    private final String lower;

    private HyphenRange(String lower, String upper, @Nullable String metadataPattern) {
        super(metadataPattern);
        this.lower = lower;
        this.upper = upper;
    }

    @Override
    public boolean isValid(@Nullable String currentVersion, String version) {
        return super.isValid(currentVersion, version) && super.compare(currentVersion, version, this.upper) <= 0 && super.compare(currentVersion, version, this.lower) >= 0;
    }

    public static Validated build(String pattern, @Nullable String metadataPattern) {
        Matcher matcher = HYPHEN_RANGE_PATTERN.matcher(pattern);
        if (!matcher.matches()) {
            return Validated.invalid("hyphenRange", pattern, "not a hyphen range");
        }
        return Validated.valid("hyphenRange", new HyphenRange(matcher.group(1), matcher.group(5), metadataPattern));
    }
}

