/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.scheduling;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import org.openrewrite.RecipeScheduler;

public class ForkJoinScheduler
implements RecipeScheduler {
    private static final ForkJoinScheduler COMMON_SCHEDULER = new ForkJoinScheduler(new ForkJoinPool((int)((double)Runtime.getRuntime().availableProcessors() * 1.25)));
    private final ForkJoinPool forkJoinPool;

    public static ForkJoinScheduler common() {
        return COMMON_SCHEDULER;
    }

    @Override
    public <T> CompletableFuture<T> schedule(Callable<T> fn) {
        CompletableFuture f = new CompletableFuture();
        this.forkJoinPool.submit(() -> {
            try {
                Object obj = fn.call();
                f.complete(obj);
            }
            catch (Throwable t) {
                f.completeExceptionally(t);
            }
        });
        return f;
    }

    public ForkJoinPool getForkJoinPool() {
        return this.forkJoinPool;
    }

    public static void shutdown() {
        COMMON_SCHEDULER.getForkJoinPool().shutdown();
    }

    public ForkJoinScheduler(ForkJoinPool forkJoinPool) {
        this.forkJoinPool = forkJoinPool;
    }
}

