/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;

public interface Parser<S extends SourceFile> {
    default public List<S> parse(Iterable<Path> sourceFiles, @Nullable Path relativeTo, ExecutionContext ctx) {
        return this.parseInputs(StreamSupport.stream(sourceFiles.spliterator(), false).map(sourceFile -> new Input((Path)sourceFile, () -> {
            try {
                return Files.newInputStream(sourceFile, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        })).collect(Collectors.toList()), relativeTo, ctx);
    }

    default public List<S> parse(String ... sources) {
        return this.parse(new InMemoryExecutionContext(), sources);
    }

    default public List<S> parse(ExecutionContext ctx, String ... sources) {
        return this.parseInputs(Arrays.stream(sources).map(source -> new Input(this.sourcePathFromSourceText(Paths.get(Long.toString(System.nanoTime()), new String[0]), (String)source), null, () -> new ByteArrayInputStream(source.getBytes(StandardCharsets.UTF_8)), true)).collect(Collectors.toList()), null, ctx);
    }

    public List<S> parseInputs(Iterable<Input> var1, @Nullable Path var2, ExecutionContext var3);

    public boolean accept(Path var1);

    default public boolean accept(Input input) {
        return input.isSynthetic() || this.accept(input.getPath());
    }

    default public List<Input> acceptedInputs(Iterable<Input> input) {
        return StreamSupport.stream(input.spliterator(), false).filter(this::accept).collect(Collectors.toList());
    }

    default public Parser<S> reset() {
        return this;
    }

    public Path sourcePathFromSourceText(Path var1, String var2);

    public static class Input {
        private final boolean synthetic;
        private final Path path;
        private final Supplier<InputStream> source;
        @Nullable
        private final FileAttributes fileAttributes;

        public Input(Path path, Supplier<InputStream> source) {
            this(path, FileAttributes.fromPath(path), source, false);
        }

        public Input(Path path, @Nullable FileAttributes fileAttributes, Supplier<InputStream> source) {
            this(path, fileAttributes, source, false);
        }

        public Input(Path path, @Nullable FileAttributes fileAttributes, Supplier<InputStream> source, boolean synthetic) {
            this.path = path;
            this.fileAttributes = fileAttributes;
            this.source = source;
            this.synthetic = synthetic;
        }

        public static Input fromString(String source) {
            return Input.fromString(source, StandardCharsets.UTF_8);
        }

        public static Input fromString(String source, Charset charset) {
            return new Input(Paths.get(Long.toString(System.nanoTime()), new String[0]), null, () -> new ByteArrayInputStream(source.getBytes(charset)), true);
        }

        public static Input fromResource(String resource) {
            return new Input(Paths.get(Long.toString(System.nanoTime()), new String[0]), null, () -> Input.class.getResourceAsStream(resource), true);
        }

        public static List<Input> fromResource(String resource, String delimiter) {
            return Arrays.stream(StringUtils.readFully(Input.class.getResourceAsStream(resource)).split(delimiter)).map(source -> new Input(Paths.get(Long.toString(System.nanoTime()), new String[0]), null, () -> new ByteArrayInputStream(source.getBytes(StandardCharsets.UTF_8)), true)).collect(Collectors.toList());
        }

        public Path getPath() {
            return this.path;
        }

        public Path getRelativePath(@Nullable Path relativeTo) {
            return relativeTo == null ? this.path : relativeTo.relativize(this.path);
        }

        public EncodingDetectingInputStream getSource() {
            return new EncodingDetectingInputStream(this.source.get());
        }

        public boolean isSynthetic() {
            return this.synthetic;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Input input = (Input)o;
            return Objects.equals(this.path, input.path);
        }

        public int hashCode() {
            return Objects.hash(this.path);
        }

        @Nullable
        public FileAttributes getFileAttributes() {
            return this.fileAttributes;
        }
    }
}

