/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.text;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.UUID;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.FileAttributes;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.text.PlainTextPrinter;
import org.openrewrite.text.PlainTextVisitor;

public final class PlainText
implements SourceFile,
Tree {
    private final UUID id;
    private final Path sourcePath;
    private final Markers markers;
    @Nullable
    private final String charsetName;
    private final boolean charsetBomMarked;
    @Nullable
    private final FileAttributes fileAttributes;
    @Nullable
    private final Checksum checksum;
    private final String text;

    @Override
    public Charset getCharset() {
        return this.charsetName == null ? StandardCharsets.UTF_8 : Charset.forName(this.charsetName);
    }

    public SourceFile withCharset(Charset charset) {
        return this.withCharsetName(charset.name());
    }

    @Override
    public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v instanceof PlainTextVisitor;
    }

    @Override
    public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)((PlainTextVisitor)v).visitText(this, p);
    }

    @Override
    public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
        return new PlainTextPrinter();
    }

    public PlainText(UUID id, Path sourcePath, Markers markers, @Nullable String charsetName, boolean charsetBomMarked, @Nullable FileAttributes fileAttributes, @Nullable Checksum checksum, String text) {
        this.id = id;
        this.sourcePath = sourcePath;
        this.markers = markers;
        this.charsetName = charsetName;
        this.charsetBomMarked = charsetBomMarked;
        this.fileAttributes = fileAttributes;
        this.checksum = checksum;
        this.text = text;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public Path getSourcePath() {
        return this.sourcePath;
    }

    @Override
    public Markers getMarkers() {
        return this.markers;
    }

    @Nullable
    public String getCharsetName() {
        return this.charsetName;
    }

    @Override
    public boolean isCharsetBomMarked() {
        return this.charsetBomMarked;
    }

    @Override
    @Nullable
    public FileAttributes getFileAttributes() {
        return this.fileAttributes;
    }

    public String getText() {
        return this.text;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlainText)) {
            return false;
        }
        PlainText other = (PlainText)o;
        if (this.isCharsetBomMarked() != other.isCharsetBomMarked()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Path this$sourcePath = this.getSourcePath();
        Path other$sourcePath = other.getSourcePath();
        if (this$sourcePath == null ? other$sourcePath != null : !((Object)this$sourcePath).equals(other$sourcePath)) {
            return false;
        }
        Markers this$markers = this.getMarkers();
        Markers other$markers = other.getMarkers();
        if (this$markers == null ? other$markers != null : !((Object)this$markers).equals(other$markers)) {
            return false;
        }
        String this$charsetName = this.getCharsetName();
        String other$charsetName = other.getCharsetName();
        if (this$charsetName == null ? other$charsetName != null : !this$charsetName.equals(other$charsetName)) {
            return false;
        }
        FileAttributes this$fileAttributes = this.getFileAttributes();
        FileAttributes other$fileAttributes = other.getFileAttributes();
        if (this$fileAttributes == null ? other$fileAttributes != null : !((Object)this$fileAttributes).equals(other$fileAttributes)) {
            return false;
        }
        Checksum this$checksum = this.getChecksum();
        Checksum other$checksum = other.getChecksum();
        if (this$checksum == null ? other$checksum != null : !((Object)this$checksum).equals(other$checksum)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        return !(this$text == null ? other$text != null : !this$text.equals(other$text));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCharsetBomMarked() ? 79 : 97);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Path $sourcePath = this.getSourcePath();
        result = result * 59 + ($sourcePath == null ? 43 : ((Object)$sourcePath).hashCode());
        Markers $markers = this.getMarkers();
        result = result * 59 + ($markers == null ? 43 : ((Object)$markers).hashCode());
        String $charsetName = this.getCharsetName();
        result = result * 59 + ($charsetName == null ? 43 : $charsetName.hashCode());
        FileAttributes $fileAttributes = this.getFileAttributes();
        result = result * 59 + ($fileAttributes == null ? 43 : ((Object)$fileAttributes).hashCode());
        Checksum $checksum = this.getChecksum();
        result = result * 59 + ($checksum == null ? 43 : ((Object)$checksum).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "PlainText(id=" + this.getId() + ", sourcePath=" + this.getSourcePath() + ", markers=" + this.getMarkers() + ", charsetName=" + this.getCharsetName() + ", charsetBomMarked=" + this.isCharsetBomMarked() + ", fileAttributes=" + this.getFileAttributes() + ", checksum=" + this.getChecksum() + ", text=" + this.getText() + ")";
    }

    @NonNull
    public PlainText withId(UUID id) {
        return this.id == id ? this : new PlainText(id, this.sourcePath, this.markers, this.charsetName, this.charsetBomMarked, this.fileAttributes, this.checksum, this.text);
    }

    @NonNull
    public PlainText withSourcePath(Path sourcePath) {
        return this.sourcePath == sourcePath ? this : new PlainText(this.id, sourcePath, this.markers, this.charsetName, this.charsetBomMarked, this.fileAttributes, this.checksum, this.text);
    }

    @NonNull
    public PlainText withMarkers(Markers markers) {
        return this.markers == markers ? this : new PlainText(this.id, this.sourcePath, markers, this.charsetName, this.charsetBomMarked, this.fileAttributes, this.checksum, this.text);
    }

    @NonNull
    public PlainText withCharsetBomMarked(boolean charsetBomMarked) {
        return this.charsetBomMarked == charsetBomMarked ? this : new PlainText(this.id, this.sourcePath, this.markers, this.charsetName, charsetBomMarked, this.fileAttributes, this.checksum, this.text);
    }

    @NonNull
    public PlainText withFileAttributes(@Nullable FileAttributes fileAttributes) {
        return this.fileAttributes == fileAttributes ? this : new PlainText(this.id, this.sourcePath, this.markers, this.charsetName, this.charsetBomMarked, fileAttributes, this.checksum, this.text);
    }

    @NonNull
    public PlainText withText(String text) {
        return this.text == text ? this : new PlainText(this.id, this.sourcePath, this.markers, this.charsetName, this.charsetBomMarked, this.fileAttributes, this.checksum, text);
    }

    @NonNull
    private PlainText withCharsetName(@Nullable String charsetName) {
        return this.charsetName == charsetName ? this : new PlainText(this.id, this.sourcePath, this.markers, charsetName, this.charsetBomMarked, this.fileAttributes, this.checksum, this.text);
    }

    @NonNull
    public PlainText withChecksum(@Nullable Checksum checksum) {
        return this.checksum == checksum ? this : new PlainText(this.id, this.sourcePath, this.markers, this.charsetName, this.charsetBomMarked, this.fileAttributes, checksum, this.text);
    }

    @Override
    @Nullable
    public Checksum getChecksum() {
        return this.checksum;
    }
}

