/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.text;

import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextVisitor;

public class ChangeText
extends Recipe {
    @Option(displayName="Text after change", description="The text file will have only this text after the change.", example="Some text.")
    private final String toText;

    public ChangeText(String toText) {
        this.toText = toText;
    }

    @Override
    public Set<String> getTags() {
        return Collections.singleton("plain text");
    }

    @Override
    public String getDisplayName() {
        return "Change text";
    }

    @Override
    public String getDescription() {
        return "Completely replaces the contents of the text file with other text.";
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ChangeTextVisitor();
    }

    @Override
    public Validated validate() {
        return Validated.required("toText", this.toText);
    }

    private class ChangeTextVisitor
    extends PlainTextVisitor<ExecutionContext> {
        private ChangeTextVisitor() {
        }

        @Override
        public PlainText preVisit(PlainText tree, ExecutionContext ctx) {
            return tree.withText(ChangeText.this.toText);
        }
    }
}

