/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marker;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.UUID;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.ci.BuildEnvironment;
import org.openrewrite.marker.ci.JenkinsBuildEnvironment;
import org.openrewrite.shaded.jgit.api.Git;
import org.openrewrite.shaded.jgit.api.errors.GitAPIException;
import org.openrewrite.shaded.jgit.lib.ObjectId;
import org.openrewrite.shaded.jgit.lib.Repository;
import org.openrewrite.shaded.jgit.lib.RepositoryBuilder;
import org.openrewrite.shaded.jgit.lib.StoredConfig;
import org.openrewrite.shaded.jgit.transport.RemoteConfig;

public final class GitProvenance
implements Marker {
    private final UUID id;
    @Nullable
    private final String origin;
    @Nullable
    private final String branch;
    private final String change;

    @Nullable
    public String getOrganizationName() {
        int firstSlashPos;
        if (this.origin == null) {
            return null;
        }
        String path = this.origin.startsWith("git") ? this.origin.substring(this.origin.indexOf(58) + 1) : URI.create(this.origin).getPath().substring(1);
        int secondSlashPos = path.lastIndexOf(47, (firstSlashPos = path.lastIndexOf(47)) - 1);
        if (secondSlashPos > -1) {
            return path.substring(secondSlashPos + 1, firstSlashPos);
        }
        if (firstSlashPos > -1) {
            return path.substring(0, firstSlashPos);
        }
        return "";
    }

    @Nullable
    public String getRepositoryName() {
        if (this.origin == null) {
            return null;
        }
        if (this.origin.startsWith("git")) {
            return this.origin.substring(this.origin.lastIndexOf(47) + 1).replaceAll("\\.git$", "");
        }
        String path = URI.create(this.origin).getPath();
        return path.substring(path.lastIndexOf(47) + 1).replaceAll("\\.git$", "");
    }

    @Deprecated
    @Nullable
    public static GitProvenance fromProjectDirectory(Path projectDir) {
        return GitProvenance.fromProjectDirectory(projectDir, null);
    }

    @Nullable
    public static GitProvenance fromProjectDirectory(Path projectDir, @Nullable BuildEnvironment buildEnvironment) {
        Object repository = ((RepositoryBuilder)new RepositoryBuilder().findGitDir(projectDir.toFile())).build();
        try {
            String branch = null;
            String changeset = GitProvenance.getChangeset(repository);
            if (!((Repository)repository).getBranch().equals(changeset)) {
                branch = ((Repository)repository).getBranch();
            } else if (buildEnvironment instanceof JenkinsBuildEnvironment) {
                JenkinsBuildEnvironment jenkins = (JenkinsBuildEnvironment)buildEnvironment;
                String string = branch = jenkins.getLocalBranch() != null ? jenkins.getLocalBranch() : GitProvenance.localBranchName(repository, jenkins.getBranch());
            }
            if (branch == null) {
                Git git = Git.open(((Repository)repository).getDirectory());
                ObjectId commit = ((Repository)repository).resolve("HEAD");
                Object branchesByCommit = git.nameRev().addPrefix("refs/heads/").add(commit).call();
                if (branchesByCommit.containsKey(commit)) {
                    branch = (String)branchesByCommit.get(commit);
                    if (branch.contains("^")) {
                        branch = branch.substring(0, branch.indexOf(94));
                    } else if (branch.contains("~")) {
                        branch = branch.substring(0, branch.indexOf(126));
                    }
                } else {
                    branchesByCommit = git.nameRev().add(commit).call();
                    branch = GitProvenance.localBranchName(repository, (String)branchesByCommit.get(commit));
                }
            }
            GitProvenance gitProvenance = new GitProvenance(Tree.randomId(), GitProvenance.getOrigin(repository), branch, changeset);
            if (repository != null) {
                ((Repository)repository).close();
            }
            return gitProvenance;
        }
        catch (Throwable throwable) {
            try {
                if (repository != null) {
                    try {
                        ((Repository)repository).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (IllegalArgumentException | GitAPIException e) {
                return null;
            }
        }
    }

    @Nullable
    private static String localBranchName(Repository repository, @Nullable String remoteBranch) throws IOException, GitAPIException {
        if (remoteBranch == null) {
            return null;
        }
        String branch = null;
        try {
            Git git = Git.open(repository.getDirectory());
            Object remotes = git.remoteList().call();
            Iterator iterator = remotes.iterator();
            while (iterator.hasNext()) {
                RemoteConfig remote = (RemoteConfig)iterator.next();
                if (!remoteBranch.startsWith(remote.getName()) || branch != null && branch.length() <= remoteBranch.length() - remote.getName().length() - 1) continue;
                branch = remoteBranch.substring(remote.getName().length() + 1);
            }
        }
        catch (GitAPIException gitAPIException) {
            // empty catch block
        }
        return branch;
    }

    @Nullable
    private static String getOrigin(Repository repository) {
        StoredConfig storedConfig = repository.getConfig();
        String url = storedConfig.getString("remote", "origin", "url");
        if (url == null) {
            return null;
        }
        if (url.startsWith("https://") || url.startsWith("http://")) {
            url = GitProvenance.hideSensitiveInformation(url);
        }
        return url;
    }

    @Nullable
    private static String getChangeset(Repository repository) throws IOException {
        ObjectId head = repository.resolve("HEAD");
        if (head == null) {
            return null;
        }
        return head.getName();
    }

    private static String hideSensitiveInformation(String url) {
        try {
            String credentials = URI.create(url).toURL().getUserInfo();
            if (credentials != null) {
                return url.replaceFirst(credentials, credentials.replaceFirst(":.*", ""));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to remove credentials from repository URL. {0}", e);
        }
        return url;
    }

    public GitProvenance(UUID id, @Nullable String origin, @Nullable String branch, String change) {
        this.id = id;
        this.origin = origin;
        this.branch = branch;
        this.change = change;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Nullable
    public String getOrigin() {
        return this.origin;
    }

    @Nullable
    public String getBranch() {
        return this.branch;
    }

    public String getChange() {
        return this.change;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitProvenance)) {
            return false;
        }
        GitProvenance other = (GitProvenance)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$origin = this.getOrigin();
        String other$origin = other.getOrigin();
        if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
            return false;
        }
        String this$branch = this.getBranch();
        String other$branch = other.getBranch();
        if (this$branch == null ? other$branch != null : !this$branch.equals(other$branch)) {
            return false;
        }
        String this$change = this.getChange();
        String other$change = other.getChange();
        return !(this$change == null ? other$change != null : !this$change.equals(other$change));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $origin = this.getOrigin();
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        String $branch = this.getBranch();
        result = result * 59 + ($branch == null ? 43 : $branch.hashCode());
        String $change = this.getChange();
        result = result * 59 + ($change == null ? 43 : $change.hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "GitProvenance(id=" + this.getId() + ", origin=" + this.getOrigin() + ", branch=" + this.getBranch() + ", change=" + this.getChange() + ")";
    }

    @NonNull
    public GitProvenance withId(UUID id) {
        return this.id == id ? this : new GitProvenance(id, this.origin, this.branch, this.change);
    }

    @NonNull
    public GitProvenance withOrigin(@Nullable String origin) {
        return this.origin == origin ? this : new GitProvenance(this.id, origin, this.branch, this.change);
    }

    @NonNull
    public GitProvenance withBranch(@Nullable String branch) {
        return this.branch == branch ? this : new GitProvenance(this.id, this.origin, branch, this.change);
    }

    @NonNull
    public GitProvenance withChange(String change) {
        return this.change == change ? this : new GitProvenance(this.id, this.origin, this.branch, change);
    }
}

