/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.nio.file.Path;
import java.nio.file.PathMatcher;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public final class SetFilePermissions
extends Recipe {
    @Option(displayName="File matcher", description="Permissions will be applied to matching files. This is a glob expression.", example="**/gradlew.bat")
    private final String fileMatcher;
    @Option(displayName="Readable", description="File read permission.", example="true")
    private final Boolean isReadable;
    @Option(displayName="Writable", description="File write permission.", example="true")
    private final Boolean isWritable;
    @Option(displayName="Executable", description="Files executable permission.", example="true")
    private final Boolean isExecutable;

    @Override
    public String getDisplayName() {
        return "Set File Permission Attributes";
    }

    @Override
    public String getDescription() {
        return "Set a files read, write and executable permission attributes.";
    }

    @Override
    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext executionContext) {
                SourceFile sourceFile;
                Path sourcePath;
                PathMatcher pathMatcher;
                if (tree instanceof SourceFile && (pathMatcher = (sourcePath = (sourceFile = (SourceFile)tree).getSourcePath()).getFileSystem().getPathMatcher("glob:" + SetFilePermissions.this.fileMatcher)).matches(sourcePath)) {
                    if (sourceFile.getFileAttributes() == null) {
                        sourceFile = sourceFile.withFileAttributes(new FileAttributes(null, null, null, SetFilePermissions.this.isReadable, SetFilePermissions.this.isWritable, SetFilePermissions.this.isExecutable, 0L));
                    } else {
                        FileAttributes fileAttributes = sourceFile.getFileAttributes();
                        sourceFile = sourceFile.withFileAttributes(fileAttributes.withReadable(SetFilePermissions.this.isReadable).withWritable(SetFilePermissions.this.isWritable).withExecutable(SetFilePermissions.this.isExecutable));
                    }
                    return sourceFile;
                }
                return super.visit(tree, executionContext);
            }
        };
    }

    public SetFilePermissions(String fileMatcher, Boolean isReadable, Boolean isWritable, Boolean isExecutable) {
        this.fileMatcher = fileMatcher;
        this.isReadable = isReadable;
        this.isWritable = isWritable;
        this.isExecutable = isExecutable;
    }

    public String getFileMatcher() {
        return this.fileMatcher;
    }

    public Boolean getIsReadable() {
        return this.isReadable;
    }

    public Boolean getIsWritable() {
        return this.isWritable;
    }

    public Boolean getIsExecutable() {
        return this.isExecutable;
    }

    @NonNull
    public String toString() {
        return "SetFilePermissions(fileMatcher=" + this.getFileMatcher() + ", isReadable=" + this.getIsReadable() + ", isWritable=" + this.getIsWritable() + ", isExecutable=" + this.getIsExecutable() + ")";
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetFilePermissions)) {
            return false;
        }
        SetFilePermissions other = (SetFilePermissions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isReadable = this.getIsReadable();
        Boolean other$isReadable = other.getIsReadable();
        if (this$isReadable == null ? other$isReadable != null : !((Object)this$isReadable).equals(other$isReadable)) {
            return false;
        }
        Boolean this$isWritable = this.getIsWritable();
        Boolean other$isWritable = other.getIsWritable();
        if (this$isWritable == null ? other$isWritable != null : !((Object)this$isWritable).equals(other$isWritable)) {
            return false;
        }
        Boolean this$isExecutable = this.getIsExecutable();
        Boolean other$isExecutable = other.getIsExecutable();
        if (this$isExecutable == null ? other$isExecutable != null : !((Object)this$isExecutable).equals(other$isExecutable)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof SetFilePermissions;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isReadable = this.getIsReadable();
        result = result * 59 + ($isReadable == null ? 43 : ((Object)$isReadable).hashCode());
        Boolean $isWritable = this.getIsWritable();
        result = result * 59 + ($isWritable == null ? 43 : ((Object)$isWritable).hashCode());
        Boolean $isExecutable = this.getIsExecutable();
        result = result * 59 + ($isExecutable == null ? 43 : ((Object)$isExecutable).hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }
}

