/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.text;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.UUID;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.text.PlainTextPrinter;
import org.openrewrite.text.PlainTextVisitor;

public final class PlainText
implements SourceFile,
Tree {
    private final UUID id;
    private final Path sourcePath;
    @Nullable
    private final String charsetName;
    private final boolean charsetBomMarked;
    private final Markers markers;
    private final String text;

    @Override
    public Charset getCharset() {
        return this.charsetName == null ? StandardCharsets.UTF_8 : Charset.forName(this.charsetName);
    }

    @Override
    public SourceFile withCharset(Charset charset) {
        return this.withCharsetName(charset.name());
    }

    @Override
    public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v instanceof PlainTextVisitor;
    }

    @Override
    public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)((PlainTextVisitor)v).visitText(this, p);
    }

    @Override
    public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
        return new PlainTextPrinter();
    }

    public PlainText(UUID id, Path sourcePath, @Nullable String charsetName, boolean charsetBomMarked, Markers markers, String text) {
        this.id = id;
        this.sourcePath = sourcePath;
        this.charsetName = charsetName;
        this.charsetBomMarked = charsetBomMarked;
        this.markers = markers;
        this.text = text;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public Path getSourcePath() {
        return this.sourcePath;
    }

    @Nullable
    public String getCharsetName() {
        return this.charsetName;
    }

    @Override
    public Markers getMarkers() {
        return this.markers;
    }

    public String getText() {
        return this.text;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlainText)) {
            return false;
        }
        PlainText other = (PlainText)o;
        if (this.isCharsetBomMarked() != other.isCharsetBomMarked()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Path this$sourcePath = this.getSourcePath();
        Path other$sourcePath = other.getSourcePath();
        if (this$sourcePath == null ? other$sourcePath != null : !((Object)this$sourcePath).equals(other$sourcePath)) {
            return false;
        }
        String this$charsetName = this.getCharsetName();
        String other$charsetName = other.getCharsetName();
        if (this$charsetName == null ? other$charsetName != null : !this$charsetName.equals(other$charsetName)) {
            return false;
        }
        Markers this$markers = this.getMarkers();
        Markers other$markers = other.getMarkers();
        if (this$markers == null ? other$markers != null : !((Object)this$markers).equals(other$markers)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        return !(this$text == null ? other$text != null : !this$text.equals(other$text));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCharsetBomMarked() ? 79 : 97);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Path $sourcePath = this.getSourcePath();
        result = result * 59 + ($sourcePath == null ? 43 : ((Object)$sourcePath).hashCode());
        String $charsetName = this.getCharsetName();
        result = result * 59 + ($charsetName == null ? 43 : $charsetName.hashCode());
        Markers $markers = this.getMarkers();
        result = result * 59 + ($markers == null ? 43 : ((Object)$markers).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "PlainText(id=" + this.getId() + ", sourcePath=" + this.getSourcePath() + ", charsetName=" + this.getCharsetName() + ", charsetBomMarked=" + this.isCharsetBomMarked() + ", markers=" + this.getMarkers() + ", text=" + this.getText() + ")";
    }

    @NonNull
    public PlainText withId(UUID id) {
        return this.id == id ? this : new PlainText(id, this.sourcePath, this.charsetName, this.charsetBomMarked, this.markers, this.text);
    }

    @Override
    @NonNull
    public PlainText withSourcePath(Path sourcePath) {
        return this.sourcePath == sourcePath ? this : new PlainText(this.id, sourcePath, this.charsetName, this.charsetBomMarked, this.markers, this.text);
    }

    @NonNull
    public PlainText withMarkers(Markers markers) {
        return this.markers == markers ? this : new PlainText(this.id, this.sourcePath, this.charsetName, this.charsetBomMarked, markers, this.text);
    }

    @NonNull
    public PlainText withText(String text) {
        return this.text == text ? this : new PlainText(this.id, this.sourcePath, this.charsetName, this.charsetBomMarked, this.markers, text);
    }

    @NonNull
    private PlainText withCharsetName(@Nullable String charsetName) {
        return this.charsetName == charsetName ? this : new PlainText(this.id, this.sourcePath, charsetName, this.charsetBomMarked, this.markers, this.text);
    }

    @Override
    @NonNull
    public PlainText withCharsetBomMarked(boolean charsetBomMarked) {
        return this.charsetBomMarked == charsetBomMarked ? this : new PlainText(this.id, this.sourcePath, this.charsetName, charsetBomMarked, this.markers, this.text);
    }

    @Override
    public boolean isCharsetBomMarked() {
        return this.charsetBomMarked;
    }
}

