/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.semver;

import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.regex.Pattern;
import org.openrewrite.internal.lang.Nullable;

public interface VersionComparator
extends Comparator<String> {
    public static final Pattern RELEASE_PATTERN = Pattern.compile("(\\d+)(?:\\.(\\d+))?(?:\\.(\\d+))?(?:\\.(\\d+))?([-+].*)?");
    public static final Pattern PRE_RELEASE_ENDING = Pattern.compile("[.-](SNAPSHOT|RC|rc|M|m|beta|alpha)[.-]?\\d*$");

    @Deprecated
    default public boolean isValid(String version) {
        return this.isValid(null, version);
    }

    public boolean isValid(@Nullable String var1, String var2);

    @Override
    @Deprecated
    default public int compare(String v1, String v2) {
        return this.compare(null, v1, v2);
    }

    public int compare(@Nullable String var1, String var2, String var3);

    default public Optional<String> upgrade(String currentVersion, Collection<String> availableVersions) {
        boolean seen = false;
        String best = null;
        for (String availableVersion : availableVersions) {
            if (!this.isValid(currentVersion, availableVersion) || this.compare(currentVersion, currentVersion, availableVersion) > 0 || seen && this.compare(currentVersion, availableVersion, best) <= 0) continue;
            seen = true;
            best = availableVersion;
        }
        return (seen ? Optional.of(best) : Optional.empty()).filter(v -> !v.equals(currentVersion));
    }
}

