/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.shaded.jgit.diff.DiffEntry;
import org.openrewrite.shaded.jgit.diff.DiffFormatter;
import org.openrewrite.shaded.jgit.internal.storage.dfs.DfsRepositoryDescription;
import org.openrewrite.shaded.jgit.internal.storage.dfs.InMemoryRepository;
import org.openrewrite.shaded.jgit.lib.FileMode;
import org.openrewrite.shaded.jgit.lib.ObjectInserter;

public class Result {
    @Nullable
    private final SourceFile before;
    @Nullable
    private final SourceFile after;
    private final Collection<Stack<Recipe>> recipes;
    @Nullable
    private final Duration timeSavings;
    @Nullable
    private transient WeakReference<String> diff;
    @Nullable
    private Path relativeTo;

    @Deprecated
    public Set<Recipe> getRecipesThatMadeChanges() {
        return this.recipes.stream().map(Stack::peek).collect(Collectors.toSet());
    }

    @Incubating(since="7.22.0")
    public List<RecipeDescriptor> getRecipeDescriptorsThatMadeChanges() {
        ArrayList<RecipeDescriptor> recipesToDisplay = new ArrayList<RecipeDescriptor>();
        for (Stack<Recipe> currentStack : this.recipes) {
            RecipeDescriptor index;
            Recipe root = (Recipe)currentStack.get(1);
            RecipeDescriptor rootDescriptor = root.getDescriptor().withRecipeList(new ArrayList<RecipeDescriptor>());
            if (recipesToDisplay.contains(rootDescriptor)) {
                index = (RecipeDescriptor)recipesToDisplay.get(recipesToDisplay.indexOf(rootDescriptor));
            } else {
                recipesToDisplay.add(rootDescriptor);
                index = rootDescriptor;
            }
            for (int i = 2; i < currentStack.size(); ++i) {
                RecipeDescriptor nextDescriptor = ((Recipe)currentStack.get(i)).getDescriptor().withRecipeList(new ArrayList<RecipeDescriptor>());
                if (index.getRecipeList().contains(nextDescriptor)) {
                    index = index.getRecipeList().get(index.getRecipeList().indexOf(nextDescriptor));
                    continue;
                }
                index.getRecipeList().add(nextDescriptor);
                index = nextDescriptor;
            }
        }
        return recipesToDisplay;
    }

    public Result(@Nullable SourceFile before, @Nullable SourceFile after, Collection<Stack<Recipe>> recipes) {
        this.before = before;
        this.after = after;
        this.recipes = recipes;
        Duration timeSavings = null;
        for (Stack<Recipe> recipesStack : recipes) {
            Duration perOccurrence = recipesStack.peek().getEstimatedEffortPerOccurrence();
            if (perOccurrence == null) continue;
            timeSavings = timeSavings == null ? perOccurrence : timeSavings.plus(perOccurrence);
        }
        this.timeSavings = timeSavings;
    }

    public String diff() {
        return this.diff(null);
    }

    public String diff(@Nullable Path relativeTo) {
        String d;
        if (this.diff == null) {
            d = this.computeDiff(relativeTo);
            this.diff = new WeakReference<String>(d);
        } else {
            d = (String)this.diff.get();
            if (d == null || !Objects.equals(this.relativeTo, relativeTo)) {
                d = this.computeDiff(relativeTo);
                this.diff = new WeakReference<String>(d);
            }
        }
        return d;
    }

    private String computeDiff(@Nullable Path relativeTo) {
        Path sourcePath = this.after != null ? this.after.getSourcePath() : (this.before != null ? this.before.getSourcePath() : (relativeTo == null ? Paths.get(".", new String[0]) : relativeTo).resolve("partial-" + System.nanoTime()));
        Path originalSourcePath = sourcePath;
        if (this.before != null && this.after != null && !this.before.getSourcePath().equals(this.after.getSourcePath())) {
            originalSourcePath = this.before.getSourcePath();
        }
        try (InMemoryDiffEntry diffEntry = new InMemoryDiffEntry(originalSourcePath, sourcePath, relativeTo, this.before == null ? "" : this.before.printAll(), this.after == null ? "" : this.after.printAll(), this.recipes.stream().map(Stack::peek).collect(Collectors.toSet()));){
            this.relativeTo = relativeTo;
            String string = diffEntry.getDiff();
            return string;
        }
    }

    public String toString() {
        return this.diff();
    }

    @Nullable
    public SourceFile getBefore() {
        return this.before;
    }

    @Nullable
    public SourceFile getAfter() {
        return this.after;
    }

    public Collection<Stack<Recipe>> getRecipes() {
        return this.recipes;
    }

    @Nullable
    public Duration getTimeSavings() {
        return this.timeSavings;
    }

    static class InMemoryDiffEntry
    extends DiffEntry
    implements AutoCloseable {
        private final InMemoryRepository repo;
        private final Set<Recipe> recipesThatMadeChanges;

        InMemoryDiffEntry(Path originalFilePath, Path filePath, @Nullable Path relativeTo, String oldSource, String newSource, Set<Recipe> recipesThatMadeChanges) {
            this.changeType = originalFilePath.equals(filePath) ? DiffEntry.ChangeType.MODIFY : DiffEntry.ChangeType.RENAME;
            this.recipesThatMadeChanges = recipesThatMadeChanges;
            this.oldPath = (relativeTo == null ? originalFilePath : relativeTo.relativize(originalFilePath)).toString().replace("\\", "/");
            this.newPath = (relativeTo == null ? filePath : relativeTo.relativize(filePath)).toString().replace("\\", "/");
            try {
                this.repo = ((InMemoryRepository.Builder)new InMemoryRepository.Builder().setRepositoryDescription(new DfsRepositoryDescription())).build();
                ObjectInserter inserter = this.repo.getObjectDatabase().newInserter();
                this.oldId = inserter.insert(3, oldSource.getBytes(StandardCharsets.UTF_8)).abbreviate(40);
                this.newId = inserter.insert(3, newSource.getBytes(StandardCharsets.UTF_8)).abbreviate(40);
                inserter.flush();
                this.oldMode = FileMode.REGULAR_FILE;
                this.newMode = FileMode.REGULAR_FILE;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        String getDiff() {
            if (this.oldId.equals(this.newId) && this.oldPath.equals(this.newPath)) {
                return "";
            }
            ByteArrayOutputStream patch = new ByteArrayOutputStream();
            try (DiffFormatter formatter = new DiffFormatter(patch);){
                formatter.setRepository(this.repo);
                formatter.format(this);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            String diff = patch.toString();
            AtomicBoolean addedComment = new AtomicBoolean(false);
            return Arrays.stream(diff.split("\n")).map(l -> {
                if (!addedComment.get() && l.startsWith("@@") && l.endsWith("@@")) {
                    addedComment.set(true);
                    return l + this.recipesThatMadeChanges.stream().map(Recipe::getName).sorted().collect(Collectors.joining(", ", " ", ""));
                }
                return l;
            }).collect(Collectors.joining("\n")) + "\n";
        }

        @Override
        public void close() {
            this.repo.close();
        }
    }
}

