/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.polyglot;

import java.util.Arrays;
import java.util.UUID;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyObject;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;

public class PolyglotTree<T extends Tree>
implements Tree,
ProxyObject {
    private static final String[] MEMBERS = new String[]{"getId", "accept"};
    private final T delegate;

    public PolyglotTree(T delegate) {
        this.delegate = delegate;
    }

    @Override
    public UUID getId() {
        return this.delegate.getId();
    }

    public <T2 extends Tree> T2 withId(UUID id) {
        return (T2)this.delegate.withId(id);
    }

    @Override
    public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return this.delegate.isAcceptable(v, p);
    }

    public Object getMember(String key) {
        switch (key) {
            case "getId": {
                return args -> {
                    assert (args.length == 0);
                    return this.delegate.getId();
                };
            }
            case "accept": {
                return args -> {
                    assert (args.length == 2);
                    return Value.asValue(this.delegate.accept((TreeVisitor)args[0].as(TreeVisitor.class), (Value)args[1]));
                };
            }
        }
        return null;
    }

    public Object getMemberKeys() {
        return Value.asValue((Object)MEMBERS);
    }

    public boolean hasMember(String key) {
        return Arrays.binarySearch(MEMBERS, key) > -1;
    }

    public void putMember(String key, Value value) {
        throw new UnsupportedOperationException();
    }
}

