/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.polyglot;

import java.lang.reflect.Constructor;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.graalvm.polyglot.TypeLiteral;
import org.graalvm.polyglot.Value;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.config.OptionDescriptor;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.polyglot.PolyglotMapping;
import org.openrewrite.polyglot.PolyglotRecipe;
import org.openrewrite.polyglot.PolyglotTree;
import org.openrewrite.polyglot.PolyglotUtils;

public interface PolyglotValueMappings {
    public static final TypeLiteral<String> STRING_TYPE = new TypeLiteral<String>(){};
    public static final TypeLiteral<Boolean> BOOLEAN_TYPE = new TypeLiteral<Boolean>(){};
    public static final TypeLiteral<Set<String>> STRING_SET_TYPE = new TypeLiteral<Set<String>>(){};
    public static final TypeLiteral<List<String>> STRING_LIST_TYPE = new TypeLiteral<List<String>>(){};
    public static final TypeLiteral<Duration> DURATION_TYPE = new TypeLiteral<Duration>(){};
    public static final TypeLiteral<URI> URI_TYPE = new TypeLiteral<URI>(){};
    public static final TypeLiteral<List> RAW_LIST_TYPE = new TypeLiteral<List>(){};
    public static final TypeLiteral<List<OptionDescriptor>> OPTIONS_TYPE = new TypeLiteral<List<OptionDescriptor>>(){};
    public static final TypeLiteral<List<Marker>> MARKERS = new TypeLiteral<List<Marker>>(){};

    public static Predicate<Value> hasMeta() {
        return v -> v.getMetaObject() != null && v.getMetaObject().hasMember("meta");
    }

    public static Predicate<Value> hasName() {
        return v -> v.canInvokeMember("getName") || v.hasMember("name");
    }

    public static Predicate<Value> hasGetVisitor() {
        return v -> v.canInvokeMember("getVisitor");
    }

    public static Predicate<Value> hasDisplayName() {
        return v -> v.canInvokeMember("getDisplayName") || v.hasMember("displayName");
    }

    public static class ConstructorMappingBuilder<T> {
        private final Value parent;
        private final Constructor<?> ctor;
        private final Object[] constructorArgs;
        private int argIdx = 0;

        public ConstructorMappingBuilder(Value parent, Class<T> targetType) {
            this(parent, targetType, ctor -> true);
        }

        public ConstructorMappingBuilder(Value parent, Class<T> targetType, Predicate<Constructor<?>> ctorFn) {
            this.parent = parent;
            this.ctor = Stream.of(targetType.getConstructors()).filter(ctorFn).findFirst().orElseThrow(RuntimeException::new);
            this.constructorArgs = new Object[this.ctor.getParameterCount()];
        }

        public <O> ConstructorMappingBuilder<T> withRawValue(O property, TypeLiteral<O> targetType) {
            return this.withPropertyOrDefault(null, property, targetType);
        }

        public <O> ConstructorMappingBuilder<T> withProperty(String property, TypeLiteral<O> targetType) {
            return this.withPropertyOrDefault(property, null, targetType);
        }

        public <O> ConstructorMappingBuilder<T> withGetterOrMetaProperty(String getter, @Nullable String property, TypeLiteral<O> targetType) {
            return this.withGetterOrMetaProperty(getter, property, null, targetType);
        }

        public <O> ConstructorMappingBuilder<T> withGetterOrMetaProperty(String getter, @Nullable String property, @Nullable O defaultValue, TypeLiteral<O> targetType) {
            int i = this.argIdx++;
            this.constructorArgs[i] = this.parent.hasMember(getter) && this.parent.getMember(getter).canExecute() ? this.parent.getMember(getter).execute(new Object[0]).as(targetType) : (property != null && this.parent.getMetaObject().getMember("meta").hasMember(property) ? this.parent.getMetaObject().getMember("meta").getMember(property).as(targetType) : defaultValue);
            return this;
        }

        public <O> ConstructorMappingBuilder<T> withPropertyOrDefault(@Nullable String property, @Nullable O defaultValue, TypeLiteral<O> targetType) {
            int i = this.argIdx++;
            this.constructorArgs[i] = property != null && this.parent.hasMember(property) ? this.parent.getMember(property).as(targetType) : defaultValue;
            return this;
        }

        public T build() {
            try {
                return (T)this.ctor.newInstance(this.constructorArgs);
            }
            catch (Throwable t) {
                throw new IllegalStateException(t.getMessage(), t);
            }
        }
    }

    public static class PolyglotTreeMapping
    implements ToValuePolyglotMapping<Tree> {
        @Override
        public Class<Tree> inputType() {
            return Tree.class;
        }

        @Override
        public Value apply(Tree tree) {
            return Value.asValue(new PolyglotTree<Tree>(tree));
        }

        @Override
        public boolean test(Tree tree) {
            return true;
        }
    }

    public static class MarkersMapping
    implements FromValuePolyglotMapping<Markers> {
        @Override
        public Class<Markers> outputType() {
            return Markers.class;
        }

        @Override
        public Markers apply(Value value) {
            return Markers.build((Collection)value.invokeMember("entries", new Object[0]).as(MARKERS));
        }

        @Override
        public boolean test(Value value) {
            return value.canInvokeMember("entries");
        }
    }

    public static class TreeVisitorMapping
    implements FromValuePolyglotMapping<TreeVisitor> {
        @Override
        public Class<TreeVisitor> outputType() {
            return TreeVisitor.class;
        }

        @Override
        public TreeVisitor apply(final Value value) {
            return new TreeVisitor(){

                public Tree preVisit(Tree tree, Object o) {
                    return PolyglotUtils.invokeMemberOrElse(value, "preVisit", tree, o, (x$0, x$1) -> super.preVisit(x$0, x$1));
                }

                public Tree postVisit(Tree tree, Object o) {
                    return PolyglotUtils.invokeMemberOrElse(value, "postVisit", tree, o, (x$0, x$1) -> super.postVisit(x$0, x$1));
                }

                public Markers visitMarkers(Markers markers, Object o) {
                    return PolyglotUtils.invokeMemberOrElse(value, "visitMarkers", markers, o, (x$0, x$1) -> super.visitMarkers((Markers)x$0, x$1));
                }

                public Marker visitMarker(Marker marker, Object o) {
                    return PolyglotUtils.invokeMemberOrElse(value, "visitMarker", marker, o, (x$0, x$1) -> super.visitMarker((Marker)x$0, x$1));
                }

                public Tree visit(@Nullable Tree tree, Object o) {
                    return PolyglotUtils.invokeMemberOrElse(value, "visit", tree, o, (x$0, x$1) -> super.visit((Tree)x$0, x$1));
                }
            };
        }

        @Override
        public boolean test(Value value) {
            return value.canInvokeMember("visit");
        }
    }

    public static class OptionDescriptorMapping
    implements FromValuePolyglotMapping<OptionDescriptor> {
        @Override
        public Class<OptionDescriptor> outputType() {
            return OptionDescriptor.class;
        }

        @Override
        public OptionDescriptor apply(Value value) {
            return new ConstructorMappingBuilder<OptionDescriptor>(value, OptionDescriptor.class).withProperty("name", STRING_TYPE).withProperty("type", STRING_TYPE).withProperty("displayName", STRING_TYPE).withProperty("description", STRING_TYPE).withProperty("example", STRING_TYPE).withProperty("valid", STRING_LIST_TYPE).withProperty("required", BOOLEAN_TYPE).withProperty("value", STRING_TYPE).build();
        }

        @Override
        public boolean test(Value value) {
            return value.hasMember("displayName");
        }
    }

    public static class RecipeDescriptorMapping
    implements FromValuePolyglotMapping<RecipeDescriptor> {
        @Override
        public Class<RecipeDescriptor> outputType() {
            return RecipeDescriptor.class;
        }

        @Override
        public boolean test(Value value) {
            return PolyglotValueMappings.hasMeta().test(value);
        }

        @Override
        public RecipeDescriptor apply(Value v) {
            Value meta = v.getMetaObject().getMember("meta");
            ArrayList<OptionDescriptor> options = new ArrayList<OptionDescriptor>();
            if (meta != null && meta.hasMember("options")) {
                Value opts = meta.getMember("options");
                for (String optKey : opts.getMemberKeys()) {
                    Value opt = opts.getMember(optKey);
                    opt.putMember("name", (Object)optKey);
                    options.add((OptionDescriptor)opts.getMember(optKey).as(OptionDescriptor.class));
                }
            }
            return new ConstructorMappingBuilder<RecipeDescriptor>(v, RecipeDescriptor.class).withGetterOrMetaProperty("getName", "name", STRING_TYPE).withGetterOrMetaProperty("getDisplayName", "displayName", STRING_TYPE).withGetterOrMetaProperty("getDescription", "description", STRING_TYPE).withGetterOrMetaProperty("getTags", "tags", STRING_SET_TYPE).withGetterOrMetaProperty("getEstimatedEffortPerOccurrence", "estimatedEffortPerOccurrence", Duration.ZERO, DURATION_TYPE).withRawValue(options, OPTIONS_TYPE).withGetterOrMetaProperty("getLanguages", "languages", STRING_LIST_TYPE).withGetterOrMetaProperty("getRecipeList", "recipeList", RAW_LIST_TYPE).withRawValue((URI)v.getContext().getPolyglotBindings().getMember("sourceUri").as(URI.class), URI_TYPE).build();
        }
    }

    public static class PolyglotRecipeMapping
    implements FromValuePolyglotMapping<PolyglotRecipe> {
        @Override
        public Class<PolyglotRecipe> outputType() {
            return PolyglotRecipe.class;
        }

        @Override
        public PolyglotRecipe apply(Value value) {
            Value meta = value.getMetaObject().getMember("meta");
            String name = meta.getMember("category") + "." + value.getMetaObject().getMember("member");
            return new PolyglotRecipe(name, value);
        }

        @Override
        public boolean test(Value value) {
            return PolyglotValueMappings.hasMeta().and(PolyglotValueMappings.hasGetVisitor()).test(value);
        }
    }

    public static interface ToValuePolyglotMapping<IN>
    extends PolyglotMapping<IN, Value> {
        @Override
        default public Class<Value> outputType() {
            return Value.class;
        }
    }

    public static interface FromValuePolyglotMapping<OUT>
    extends PolyglotMapping<Value, OUT> {
        @Override
        default public Class<Value> inputType() {
            return Value.class;
        }
    }
}

