/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.style;

import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.style.Style;

public class NamedStyles
implements Marker {
    private final UUID id;
    private final String name;
    private final String displayName;
    @Nullable
    private final String description;
    private final Set<String> tags;
    private final Collection<Style> styles;

    @Nullable
    public static <S extends Style> S merge(Class<S> styleClass, Iterable<? extends NamedStyles> namedStyles) {
        Style merged = null;
        for (NamedStyles namedStyles2 : namedStyles) {
            for (Style style : namedStyles2.styles) {
                if (!styleClass.isInstance(style)) continue;
                style = style.applyDefaults();
                if (merged == null) {
                    merged = style;
                    continue;
                }
                merged = merged.merge(style);
            }
        }
        return (S)merged;
    }

    public Validated validate() {
        return Validated.none();
    }

    public NamedStyles(UUID id, String name, String displayName, @Nullable String description, Set<String> tags, Collection<Style> styles) {
        this.id = id;
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.tags = tags;
        this.styles = styles;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public Collection<Style> getStyles() {
        return this.styles;
    }

    @NonNull
    public String toString() {
        return "NamedStyles(id=" + this.getId() + ", name=" + this.getName() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", tags=" + this.getTags() + ", styles=" + this.getStyles() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NamedStyles)) {
            return false;
        }
        NamedStyles other = (NamedStyles)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof NamedStyles;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }
}

