/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.polyglot;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.io.IOUtils;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.io.ByteSequence;
import org.graalvm.polyglot.proxy.ProxyObject;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.polyglot.Polyglot;
import org.openrewrite.polyglot.PolyglotMapping;
import org.openrewrite.polyglot.PolyglotUtils;

public class PolyglotParser
implements Parser<Polyglot.Source> {
    private static final ThreadLocal<Engine> ENGINES = new InheritableThreadLocal<Engine>(){

        @Override
        protected Engine initialValue() {
            return Engine.newBuilder().allowExperimentalOptions(true).build();
        }
    };
    private final HostAccess hostAccess;
    private final ThreadLocal<Context> context = new InheritableThreadLocal<Context>(){

        @Override
        protected Context initialValue() {
            return Context.newBuilder((String[])new String[0]).engine((Engine)ENGINES.get()).allowHostAccess(PolyglotParser.this.hostAccess).allowAllAccess(true).allowExperimentalOptions(true).build();
        }
    };

    public PolyglotParser() {
        HostAccess.Builder b = HostAccess.newBuilder().allowPublicAccess(true).allowAllImplementations(true).allowAllClassImplementations(true).allowArrayAccess(true).allowListAccess(true).allowBufferAccess(true).allowIterableAccess(true).allowIteratorAccess(true).allowMapAccess(true);
        ScanResult classpath = new ClassGraph().enableAllInfo().scan();
        for (ClassInfo ci : classpath.getClassesImplementing(PolyglotMapping.class)) {
            ci.getConstructorInfo().stream().findFirst().map(mi -> {
                try {
                    return (PolyglotMapping)mi.loadClassAndGetConstructor().newInstance(new Object[0]);
                }
                catch (Throwable t) {
                    throw new IllegalStateException(t);
                }
            }).ifPresent(pm -> b.targetTypeMapping(pm.inputType(), pm.outputType(), (Predicate)pm, (Function)pm));
        }
        this.hostAccess = b.build();
    }

    public List<Polyglot.Source> parse(ExecutionContext ex, Source ... sources) {
        ex.putMessage("POLYGLOT_CONTEXT", this.context.get());
        return Stream.of(sources).flatMap(src -> {
            Path srcPath = Paths.get(src.getPath() == null ? src.getName() + "." + src.getLanguage() : src.getPath(), new String[0]);
            ByteArrayInputStream is = new ByteArrayInputStream(src.hasBytes() ? src.getBytes().toByteArray() : src.getCharacters().toString().getBytes(StandardCharsets.UTF_8));
            Parser.Input in = new Parser.Input(srcPath, () -> is, true);
            return this.parseInputs(Collections.singletonList(in), null, new InMemoryExecutionContext()).stream();
        }).collect(Collectors.toList());
    }

    @Override
    public List<Polyglot.Source> parseInputs(Iterable<Parser.Input> sources, @Nullable Path relativeTo, ExecutionContext ex) {
        return StreamSupport.stream(sources.spliterator(), false).map(in -> {
            Context ctx = this.context.get();
            String language = PolyglotUtils.getLanguage(in.getPath().toString());
            try {
                Source.Builder src = Source.newBuilder((String)language, (URL)in.getPath().toUri().toURL());
                if ("js".equals(language)) {
                    src.content(IOUtils.toString((InputStream)in.getSource()));
                } else {
                    src.content(ByteSequence.create((byte[])IOUtils.toByteArray((InputStream)in.getSource())));
                }
                ctx.eval(src.build());
                Value bindings = ctx.getBindings(language);
                bindings.putMember("Polyglot", (Object)new PolyglotHelper());
                ctx.getPolyglotBindings().putMember("sourceUri", (Object)in.getPath().toUri());
                return new Polyglot.Source(Tree.randomId(), Markers.EMPTY, in.getPath(), bindings);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    @Override
    public boolean accept(Path path) {
        return path.endsWith(".js");
    }

    private static class PolyglotHelper
    implements ProxyObject {
        private PolyglotHelper() {
        }

        public Object getMember(String key) {
            switch (key) {
                case "randomId": {
                    return arguments -> Value.asValue((Object)Tree.randomId());
                }
            }
            return Value.asValue(null);
        }

        public Object getMemberKeys() {
            return Value.asValue((Object)new String[]{"randomId"});
        }

        public boolean hasMember(String key) {
            switch (key) {
                case "randomId": {
                    return true;
                }
            }
            return false;
        }

        public void putMember(String key, Value value) {
        }
    }
}

