/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marker;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.UUID;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.shaded.jgit.lib.ObjectId;
import org.openrewrite.shaded.jgit.lib.Repository;
import org.openrewrite.shaded.jgit.lib.RepositoryBuilder;
import org.openrewrite.shaded.jgit.lib.StoredConfig;

@Incubating(since="7.0.0")
public class GitProvenance
implements Marker {
    private final UUID id;
    @Nullable
    private final String origin;
    private final String branch;
    private final String change;

    @Nullable
    public String getOrganizationName() {
        int firstSlashPos;
        if (this.origin == null) {
            return null;
        }
        String path = this.origin.startsWith("git") ? this.origin.substring(this.origin.indexOf(58) + 1) : URI.create(this.origin).getPath().substring(1);
        int secondSlashPos = path.lastIndexOf(47, (firstSlashPos = path.lastIndexOf(47)) - 1);
        if (secondSlashPos > -1) {
            return path.substring(secondSlashPos + 1, firstSlashPos);
        }
        if (firstSlashPos > -1) {
            return path.substring(0, firstSlashPos);
        }
        return "";
    }

    @Nullable
    public String getRepositoryName() {
        if (this.origin == null) {
            return null;
        }
        if (this.origin.startsWith("git")) {
            return this.origin.substring(this.origin.lastIndexOf(47) + 1).replaceAll("\\.git$", "");
        }
        String path = URI.create(this.origin).getPath();
        return path.substring(path.lastIndexOf(47) + 1).replaceAll("\\.git$", "");
    }

    @Nullable
    public static GitProvenance fromProjectDirectory(Path projectDir) {
        Object repository = ((RepositoryBuilder)new RepositoryBuilder().findGitDir(projectDir.toFile())).build();
        try {
            GitProvenance gitProvenance = new GitProvenance(Tree.randomId(), GitProvenance.getOrigin(repository), ((Repository)repository).getBranch(), GitProvenance.getChangeset(repository));
            if (repository != null) {
                ((Repository)repository).close();
            }
            return gitProvenance;
        }
        catch (Throwable throwable) {
            try {
                if (repository != null) {
                    try {
                        ((Repository)repository).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }

    @Nullable
    private static String getOrigin(Repository repository) {
        StoredConfig storedConfig = repository.getConfig();
        String url = storedConfig.getString("remote", "origin", "url");
        if (url == null) {
            return null;
        }
        if (url.startsWith("https://") || url.startsWith("http://")) {
            url = GitProvenance.hideSensitiveInformation(url);
        }
        return url;
    }

    @Nullable
    private static String getChangeset(Repository repository) throws IOException {
        ObjectId head = repository.resolve("HEAD");
        if (head == null) {
            return null;
        }
        return head.getName();
    }

    private static String hideSensitiveInformation(String url) {
        try {
            String credentials = URI.create(url).toURL().getUserInfo();
            if (credentials != null) {
                return url.replaceFirst(credentials, credentials.replaceFirst(":.*", ""));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to remove credentials from repository URL. {0}", e);
        }
        return url;
    }

    public GitProvenance(UUID id, @Nullable String origin, String branch, String change) {
        this.id = id;
        this.origin = origin;
        this.branch = branch;
        this.change = change;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Nullable
    public String getOrigin() {
        return this.origin;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getChange() {
        return this.change;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitProvenance)) {
            return false;
        }
        GitProvenance other = (GitProvenance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$origin = this.getOrigin();
        String other$origin = other.getOrigin();
        if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
            return false;
        }
        String this$branch = this.getBranch();
        String other$branch = other.getBranch();
        if (this$branch == null ? other$branch != null : !this$branch.equals(other$branch)) {
            return false;
        }
        String this$change = this.getChange();
        String other$change = other.getChange();
        return !(this$change == null ? other$change != null : !this$change.equals(other$change));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof GitProvenance;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $origin = this.getOrigin();
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        String $branch = this.getBranch();
        result = result * 59 + ($branch == null ? 43 : $branch.hashCode());
        String $change = this.getChange();
        result = result * 59 + ($change == null ? 43 : $change.hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "GitProvenance(id=" + this.getId() + ", origin=" + this.getOrigin() + ", branch=" + this.getBranch() + ", change=" + this.getChange() + ")";
    }
}

