/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.polyglot;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.graalvm.polyglot.TypeLiteral;
import org.graalvm.polyglot.Value;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.config.CategoryDescriptor;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.polyglot.PolyglotUtils;
import org.openrewrite.style.NamedStyles;

public class PolyglotRecipe
extends Recipe {
    private static final Value EMPTY_VISITOR = Value.asValue((Object)new TreeVisitor(){});
    private static final TypeLiteral<Set<String>> SET_OF_STRINGS = new TypeLiteral<Set<String>>(){};
    private final String name;
    private final Value value;

    public PolyglotRecipe(String name, Value value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public RecipeDescriptor getRecipeDescriptor() {
        return (RecipeDescriptor)this.value.as(RecipeDescriptor.class);
    }

    public List<CategoryDescriptor> getCategoryDescriptors() {
        return Collections.emptyList();
    }

    public List<NamedStyles> getNamedStyles() {
        return Collections.emptyList();
    }

    @Override
    public String getDisplayName() {
        return PolyglotUtils.invokeMemberOrElse(this.value, "getDisplayName", () -> Value.asValue((Object)this.name)).asString();
    }

    @Override
    public String getDescription() {
        return PolyglotUtils.invokeMemberOrElse(this.value, "getDescription", () -> Value.asValue((Object)this.name)).asString();
    }

    @Override
    public Set<String> getTags() {
        return (Set)PolyglotUtils.invokeMemberOrElse(this.value, "getTags", () -> Value.asValue(Collections.emptySet())).as(SET_OF_STRINGS);
    }

    @Override
    @Nullable
    protected TreeVisitor<?, ExecutionContext> getApplicableTest() {
        return (TreeVisitor)PolyglotUtils.invokeMemberOrElse(this.value, "getApplicableTest", () -> Value.asValue(null)).as(TreeVisitor.class);
    }

    @Override
    @Nullable
    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return (TreeVisitor)PolyglotUtils.invokeMemberOrElse(this.value, "getSingleSourceApplicableTest", () -> Value.asValue(null)).as(TreeVisitor.class);
    }

    @Override
    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return (TreeVisitor)PolyglotUtils.invokeMemberOrElse(this.value, "getVisitor", () -> EMPTY_VISITOR).as(TreeVisitor.class);
    }

    public String toString() {
        return "$classname{ value: " + this.value + " }";
    }
}

