/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.polyglot;

import java.util.Optional;
import java.util.Set;
import org.graalvm.polyglot.Value;

public class PolyglotUtils {
    public static final String JS = "js";

    public static Optional<Value> getOption(Value value, String memberKey) {
        return PolyglotUtils.getValue(value, "options").flatMap(v -> Optional.ofNullable(v.getMember(memberKey)));
    }

    public static Optional<Value> getValue(Value value, String memberKey) {
        return Optional.ofNullable(value.getMember(memberKey));
    }

    public static Optional<Value> invokeMember(Value value, String memberKey, Object ... args) {
        return PolyglotUtils.getValue(value, memberKey).filter(Value::canExecute).map(v -> v.execute(args));
    }

    public static Value invokeMemberOrElse(Value value, String memberKey, Value orElse, Object ... args) {
        return PolyglotUtils.getValue(value, memberKey).filter(Value::canExecute).map(v -> v.execute(args)).orElse(orElse);
    }

    public static Optional<Value> jsExtend(Value value, String member, String name, Object obj) {
        Value bindings = value.getContext().getBindings(JS);
        Set members = bindings.getMemberKeys();
        if (members == null || members.isEmpty()) {
            return Optional.empty();
        }
        Value prototype = value.getContext().eval(JS, (CharSequence)("this.default." + member + ".prototype"));
        prototype.putMember(name, (Object)Value.asValue((Object)obj));
        return Optional.of(value);
    }
}

