/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.openrewrite.internal.lang.Nullable;

public final class ListUtils {
    private ListUtils() {
    }

    public static <T> List<T> insertInOrder(List<T> ls, T insert, Comparator<T> naturalOrdering) {
        if (ls == null || ls.isEmpty()) {
            return Collections.singletonList(insert);
        }
        ArrayList<T> ordered = new ArrayList<T>(ls);
        ordered.add(insert);
        ordered.sort(naturalOrdering);
        Object comesAfter = null;
        for (Object t : ordered) {
            if (t == insert) break;
            comesAfter = t;
        }
        ArrayList<T> newLs = new ArrayList<T>(ls);
        if (comesAfter == null) {
            newLs.add(0, insert);
        } else {
            for (int i = 0; i < newLs.size(); ++i) {
                if (newLs.get(i) != comesAfter) continue;
                newLs.add(i + 1, insert);
            }
        }
        return newLs;
    }

    public static <T> List<T> mapLast(List<T> ls, UnaryOperator<T> mapLast) {
        Object newLast;
        if (ls == null || ls.isEmpty()) {
            return ls;
        }
        T last = ls.get(ls.size() - 1);
        if (last != (newLast = mapLast.apply(last))) {
            ArrayList<T> newLs = new ArrayList<T>(ls);
            if (newLast == null) {
                newLs.remove(ls.size() - 1);
            } else {
                newLs.set(ls.size() - 1, newLast);
            }
            return newLs;
        }
        return ls;
    }

    public static <T> List<T> mapFirst(List<T> ls, UnaryOperator<T> mapFirst) {
        Object newFirst;
        if (ls == null || ls.isEmpty()) {
            return ls;
        }
        T first = ls.iterator().next();
        if (first != (newFirst = mapFirst.apply(first))) {
            ArrayList<T> newLs = new ArrayList<T>(ls);
            if (newFirst == null) {
                newLs.remove(0);
            } else {
                newLs.set(0, newFirst);
            }
            return newLs;
        }
        return ls;
    }

    public static <T> List<T> map(List<T> ls, BiFunction<Integer, T, T> map) {
        if (ls == null || ls.isEmpty()) {
            return ls;
        }
        List<T> newLs = ls;
        for (int i = 0; i < ls.size(); ++i) {
            T tree = ls.get(i);
            T newTree = map.apply(i, (Integer)tree);
            if (newTree == tree) continue;
            if (newLs == ls) {
                newLs = new ArrayList<T>(ls);
            }
            newLs.set(i, newTree);
        }
        if (newLs != ls) {
            while (newLs.remove(null)) {
            }
        }
        return newLs;
    }

    public static <T> List<T> map(List<T> ls, UnaryOperator<T> map) {
        return ListUtils.map(ls, (Integer i, T t) -> map.apply(t));
    }

    public static <T> List<T> flatMap(List<T> ls, BiFunction<Integer, T, Object> flatMap) {
        if (ls == null || ls.isEmpty()) {
            return ls;
        }
        List<T> newLs = ls;
        int j = 0;
        int i = 0;
        while (i < ls.size()) {
            T tree = ls.get(i);
            Object newTreeOrTrees = flatMap.apply(i, (Integer)tree);
            if (newTreeOrTrees != tree) {
                if (newLs == ls) {
                    newLs = new ArrayList<T>(ls);
                }
                if (newTreeOrTrees instanceof Iterable) {
                    int n = 0;
                    for (Object newTree : (Iterable)newTreeOrTrees) {
                        if (j >= newLs.size()) {
                            newLs.add(newTree);
                        } else if (n == 0) {
                            newLs.set(j, newTree);
                        } else {
                            newLs.add(j, newTree);
                        }
                        ++j;
                        ++n;
                    }
                } else if (j >= newLs.size()) {
                    newLs.add(newTreeOrTrees);
                } else {
                    newLs.set(j, newTreeOrTrees);
                }
            }
            ++i;
            ++j;
        }
        if (newLs != ls) {
            while (newLs.remove(null)) {
            }
        }
        return newLs;
    }

    public static <T> List<T> flatMap(List<T> ls, Function<T, Object> flatMap) {
        return ListUtils.flatMap(ls, (Integer i, T t) -> flatMap.apply(t));
    }

    public static <T> List<T> concat(@Nullable List<T> ls, @Nullable T t) {
        ArrayList<T> newLs;
        if (t == null && ls == null) {
            return Collections.emptyList();
        }
        ArrayList<T> arrayList = newLs = ls == null ? new ArrayList<T>(1) : new ArrayList<T>(ls);
        if (t != null) {
            newLs.add(t);
        }
        return newLs;
    }

    public static <T> List<T> concat(@Nullable T t, @Nullable List<T> ls) {
        ArrayList<T> newLs;
        if (t == null && ls == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> arrayList = newLs = ls == null ? new ArrayList<T>(1) : new ArrayList(ls.size() + 1);
        if (t != null) {
            newLs.add(t);
        }
        if (ls != null) {
            newLs.addAll(ls);
        }
        return newLs;
    }

    public static <T> List<T> concatAll(@Nullable List<T> ls, @Nullable List<T> t) {
        if (ls == null) {
            return t;
        }
        if (t == null || t.isEmpty()) {
            return ls;
        }
        ArrayList<T> newLs = new ArrayList<T>(ls);
        newLs.addAll(t);
        return newLs;
    }

    public static <T> List<T> insertAll(List<T> ls, int index, List<T> t) {
        if (ls == null) {
            return t;
        }
        if (t.isEmpty()) {
            return ls;
        }
        ArrayList<T> newLs = new ArrayList<T>(ls);
        newLs.addAll(index, t);
        return newLs;
    }
}

