/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;
import org.openrewrite.Recipe;
import org.openrewrite.config.CategoryDescriptor;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.config.RecipeExample;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.polyglot.PolyglotRecipe;
import org.openrewrite.style.NamedStyles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolyglotResourceLoader
implements ResourceLoader {
    private static final Logger log = LoggerFactory.getLogger(PolyglotResourceLoader.class);
    private final List<Recipe> recipes = new ArrayList<Recipe>();
    private final List<NamedStyles> styles = new ArrayList<NamedStyles>();
    private final List<RecipeDescriptor> recipeDescriptors = new ArrayList<RecipeDescriptor>();
    private final List<CategoryDescriptor> categoryDescriptors = new ArrayList<CategoryDescriptor>();
    private final List<RecipeExample> recipeExamples = new ArrayList<RecipeExample>();

    public PolyglotResourceLoader() {
    }

    public PolyglotResourceLoader(Source ... sources) {
        Context context = Context.newBuilder((String[])new String[0]).allowAllAccess(true).build();
        for (Source src : sources) {
            try {
                this.evalPolyglotRecipe(context, src.getName(), src);
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public Collection<Recipe> listRecipes() {
        return this.recipes;
    }

    @Override
    public Collection<RecipeDescriptor> listRecipeDescriptors() {
        return this.recipeDescriptors;
    }

    @Override
    public Collection<NamedStyles> listStyles() {
        return this.styles;
    }

    @Override
    public Collection<CategoryDescriptor> listCategoryDescriptors() {
        return this.categoryDescriptors;
    }

    @Override
    public Collection<RecipeExample> listRecipeExamples() {
        return this.recipeExamples;
    }

    public void evalPolyglotRecipe(Context context, String name, Source src) throws IOException {
        String language = src.getPath().substring(src.getPath().lastIndexOf(46) + 1);
        Value bindings = context.getBindings(language);
        context.eval(src);
        for (String exportedMember : bindings.getMemberKeys()) {
            Value defaultExport = bindings.getMember(exportedMember).getMember("default");
            if (defaultExport.canInstantiate()) {
                defaultExport = defaultExport.newInstance(new Object[0]);
            } else if (defaultExport.canExecute()) {
                defaultExport = defaultExport.execute(new Object[0]);
            }
            PolyglotRecipe r = new PolyglotRecipe(name, defaultExport);
            this.recipes.add(r);
            this.recipeDescriptors.add(r.getDescriptor());
        }
    }
}

